package com.gtis.oa.util;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.gtis.oa.config.SpringConfig;
import freemarker.cache.StringTemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.dom4j.Element;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.xml.sax.InputSource;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 日期公共类
 * @author 张顾培
 * @date 2019/7/19
 */
@Slf4j
public class CommonUtil {
    public static final Pattern NUMBER_PATTERN = Pattern.compile("[^0-9]");
    public static final Pattern NUMERIC_PATTERN = Pattern.compile("^-{0,1}[0-9]+([.]{1}[0-9]+){0,1}$");

    /**
     * 获取用户信息
     * @return
     */
    public static UserDto getUser() {
        UserManagerClient userManagerClient = SpringConfig.getBean(UserManagerClient.class);
        if (userManagerClient != null) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null) {
                String username = authentication.getName();
                if (StringUtils.isNotBlank(username)) {
                    return userManagerClient.getUserDetailByUsername(username);
                }
            }
        }
        return null;
    }

    /**
     * 获取用户id
     * @return
     */
    public static String getUserId() {
        UserDto userDto = getUser();
        if (userDto != null) {
            return userDto.getId();
        }
        return null;
    }

    /**
     * 获取用户姓名
     * @return
     */
    public static String getUsername() {
        UserDto userDto = getUser();
        if (userDto != null) {
            return userDto.getAlias();
        }
        return null;
    }

    /**
     * 获取用户regionCode
     * @return
     */
    public static String getUserRegionCode() {
        UserDto userDto = getUser();
        if (userDto != null && CollectionUtils.isNotEmpty(userDto.getOrgRecordList())) {
            return userDto.getOrgRecordList().get(0).getRegionCode();
        }
        return null;
    }

    /**
     * 获取用户regionCode
     * @param flag 为true时截取前4位，为false且为四位时后面补两位零
     * @return
     */
    public static String getUserRegionCode(boolean flag) {
        String regionCode = getUserRegionCode();
        if (StringUtils.isNotBlank(regionCode)) {
            if(flag){
                if (regionCode.length() == 6 && regionCode.endsWith("00")) {
                    regionCode = regionCode.substring(0, 4);
                }
            }else{
                if(regionCode.length() == 4){
                    regionCode = regionCode + "00";
                }
            }
        }
        return regionCode;
    }

    /**
     * 处理行政区代码
     * @param xzqdm
     * @return
     */
    public static String dealXzqdm(String xzqdm) {
        /*if (StringUtils.isBlank(xzqdm)) {
            xzqdm = getUserRegionCode();
        }*/
        if (StringUtils.length(xzqdm) == 6) {
            if (StringUtils.endsWith(xzqdm, "0000")) {
                xzqdm = StringUtils.left(xzqdm, 2);
            } else if (StringUtils.endsWith(xzqdm, "00")) {
                xzqdm = StringUtils.left(xzqdm, 4);
            }
        }
        return xzqdm;
    }
    /**
     * 初始化数字格式
     *
     * @param count
     * @return
     */
    public static DecimalFormat initDecimalFormat(Integer count) {
        return initDecimalFormat(count, true);
    }

    /**
     * 初始化数字格式
     *
     * @param count
     * @return
     */
    public static DecimalFormat initDecimalFormat(Integer count, boolean buling) {
        String formatStr = "#0.";
        if (count == null) {
            count = 8;
        }
        if (count <= 0) {
            formatStr = "#0";
        } else {
            for (int i = 0; i < count; i++) {
                if (buling) {
                    formatStr += "0";
                } else {
                    formatStr += "#";
                }
            }
        }
        DecimalFormat myformat = new DecimalFormat(formatStr);
        return myformat;
    }

    /**
     * 格式化两位小数
     *
     * @param value
     * @return
     */
    public static Double formatTwoNumber(Double value) {
        DecimalFormat df = new DecimalFormat("##############0.00");
        Double value1 = Double.parseDouble(df.format(value));
        return value1;
    }

    /**
     * 格式化4位小数
     *
     * @param value
     * @return
     */
    public static Double formatFourNumber(Double value) {
        DecimalFormat df = new DecimalFormat("##############0.0000");
        Double value1 = Double.parseDouble(df.format(value));
        return value1;
    }

    /**
     * Integer 转字符串
     * 为null返回空字符串
     *
     * @return String
     * @throws Exception
     * @应用
     */
    public static String IntegerToString(Integer integer) {
        if (integer != null) {
            return String.valueOf(integer);
        } else {
            return "";
        }
    }

    public static String bigDecimalToString(BigDecimal bigDecimalData, Integer count) {
        if (bigDecimalData == null) {
            return "";
        }

        DecimalFormat myformat = initDecimalFormat(count);
        return myformat.format(bigDecimalData);
    }

    public static String bigDecimalToString(BigDecimal bigDecimalData, Integer count, boolean buling) {
        if (bigDecimalData == null) {
            return "";
        }

        DecimalFormat myformat = initDecimalFormat(count, buling);
        return myformat.format(bigDecimalData);
    }

    public static BigDecimal stringtoBigDecimal(String bigDecimalData, Integer count) {
        try {
            if (StringUtils.isBlank(bigDecimalData) || "null".equals(bigDecimalData)) {
                return new BigDecimal(0);
            }
            DecimalFormat myformat = initDecimalFormat(count, true);
            return new BigDecimal(myformat.format(new BigDecimal(bigDecimalData)));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }

    public static BigDecimal stringtoBigDecimal(String bigDecimalData, Integer count, boolean buling) {
        try {
            if (StringUtils.isBlank(bigDecimalData) || "null".equals(bigDecimalData)) {
                return new BigDecimal(0);
            }
            DecimalFormat myformat = initDecimalFormat(count, buling);
            return new BigDecimal(myformat.format(new BigDecimal(bigDecimalData)));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }

    public static BigDecimal bigDecimalToBigDecimal(BigDecimal bigDecimalData, Integer count) {
        if (bigDecimalData == null) {
            return new BigDecimal(0);
        }
        DecimalFormat myformat = initDecimalFormat(count);
        return new BigDecimal(myformat.format(bigDecimalData));
    }

    public static BigDecimal bigDecimalToBigDecimal(BigDecimal bigDecimalData, Integer count, boolean buling) {
        if (bigDecimalData == null) {
            return new BigDecimal(0);
        }
        DecimalFormat myformat = initDecimalFormat(count, buling);
        return new BigDecimal(myformat.format(bigDecimalData));
    }

    /**
     * Double 转字符串
     * 为null返回空字符串
     *
     * @return String
     * @throws Exception
     * @应用
     */
    public static Integer DoubleToInteger(Double value) {
        Integer input = 0;
        try {
            DecimalFormat myformat = new DecimalFormat("#0");
            String s = myformat.format(value);
            input = Integer.parseInt(s);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return input;
    }


    /**
     * 将字符串类型的转为整型
     * 如果str为null或空，则返回null
     *
     * @param str
     * @return
     */
    public static Integer StringToInteger(String str) {
        Integer integer = null;
        try {
            if (str != null && !"".equals(str) && !str.equalsIgnoreCase(null)) {
                integer = Integer.valueOf(str);
            }

        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return integer;
    }

    /**
     * 获取字符串中的整数部分
     *
     * @param str
     * @return
     */
    public static String getIntegerStr(String str) {
        String numberRegEx = "[^0-9]";
        Pattern pattern = Pattern.compile(numberRegEx);
        Matcher matcher = pattern.matcher(str);
        String result = matcher.replaceAll("");
        return result;
    }

    /**
     * 获取字符串中的数字部分
     *
     * @param str
     * @return
     */
    public static String getNumberStr(String str) {
        String numberRegEx = "([^(\\d|\\.)])";
        Pattern pattern = Pattern.compile(numberRegEx);
        Matcher matcher = pattern.matcher(str);
        String result = matcher.replaceAll("");
        return result;
    }

    /**
     * 将阿拉伯数字转换程中文数字，（只支持两位数）
     *
     * @param value
     * @return
     */
    public static String paseChinaNum(int value) {
        String chinaNum = "";
        char[] valueStr = (value + "").toCharArray();

        char[] SCDigits = {'零', '一', '二', '三', '四', '五', '六', '七', '八', '九'};
        if (valueStr != null) {
            if (valueStr.length == 2) {
                if (valueStr[0] == '1') {
                    chinaNum = "十" + SCDigits[Integer.parseInt(valueStr[1] + "")];
                } else {
                    chinaNum = SCDigits[Integer.parseInt(valueStr[0] + "")] + "十" + SCDigits[Integer.parseInt(valueStr[1] + "")];
                }
            } else if (valueStr.length == 1) {
                chinaNum = SCDigits[Integer.parseInt(valueStr[0] + "")] + "";
            }
        }
        chinaNum = StringUtils.replace(chinaNum, "零", "");
        return chinaNum;
    }

    /**
     * 中文转换成阿拉伯数字
     * @param str
     * @return
     */
    public static int paseArabicNum(String str){
        String str1 = new String();
        String str2 = new String();
        String str3 = new String();
        int k = 0;
        boolean dealflag = true;
        //先把字符串中的“零"除去
        String chineseNum = StringUtils.remove(str,"零");
        for(int i=0;i<chineseNum.length();i++){
            if(chineseNum.charAt(i) == '亿'){
                str1 = chineseNum.substring(0,i);//截取亿前面的数字，逐个对比表格。然后转换
                k = i+1;
                dealflag = false;//已经处理
            }
            if(chineseNum.charAt(i) == '万'){
                str2 = chineseNum.substring(k,i);
                str3 = str.substring(i+1);
                dealflag = false;//已经处理
            }
        }
        if(dealflag){//假设没有处理
            str3 =  chineseNum;
        }
        int result = sectionChinese(str1) * 100000000 +
                sectionChinese(str2) * 10000 + sectionChinese(str3);
        return result;
    }

    public static int sectionChinese(String str){
        int value = 0;
        int sectionNum = 0;
        //数字位
        String[] chnNumChar = {"零","一","二","三","四","五","六","七","八","九"};
        char[] chnNumChinese = {'零','一','二','三','四','五','六','七','八','九'};
        HashMap<Character, Integer> intList = new HashMap();
        for(int j=0;j<chnNumChar.length;j++){
            intList.put(chnNumChinese[j], j);
        }
        intList.put('十',10);
        intList.put('百',100);
        intList.put('千', 1000);
        if(StringUtils.startsWith(str,"十")){
            str = "一" + str;
        }
        for(int i=0;i<str.length();i++){
            int v = MapUtils.getIntValue(intList,str.charAt(i));
            if( v == 10 || v == 100 || v == 1000 ){//假设数值是权位则相乘
                sectionNum = v * sectionNum;
                value = value + sectionNum;
            }else if(i == str.length()-1){
                value = value + v;
            }else{
                sectionNum = v;
            }
        }
        return value;
    }

    /**
     * 两个大数据相加
     *
     * @param aa
     * @param bb
     * @return
     */
    public static String addBigDecimal(Object aa, Object bb) {
        BigDecimal rs = BigDecimal.ZERO;
        if (aa != null && !"".equals(aa.toString())) {
            rs = rs.add(new BigDecimal(aa.toString()));
        }
        if (bb != null && !"".equals(bb.toString())) {
            rs = rs.add(new BigDecimal(bb.toString()));
        }
        if (BigDecimal.ZERO.compareTo(rs) == 0) {
            return "0";
        }
        return rs.toString();
    }

    /**
     * 检查是否位数字
     *
     * @param str
     * @return
     */
    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        return NUMERIC_PATTERN.matcher(str).matches();
    }

    /**
     * @param doubleData 字符型的double
     *                   count
     *                   保留小数位数
     * @return
     */
    public static String doubleStringToString(String doubleData, Integer count) {
        double input = 0.0;
        if (StringUtils.isBlank(doubleData) || "null".equals(doubleData)) {
            return "";
        }
        input = Double.parseDouble(doubleData);
        DecimalFormat myformat = initDecimalFormat(count);
        return myformat.format(input);
    }

    public static Double doubleToDouble(Double doubleData, Integer count) {
        if (doubleData == null) {
            return 0.0;
        }
        DecimalFormat myformat = initDecimalFormat(count);
        return new Double(myformat.format(doubleData));
    }

    public static Double doubleToDouble(Double doubleData, Integer count, boolean buling) {
        if (doubleData == null) {
            return 0.0;
        }
        DecimalFormat myformat = initDecimalFormat(count, buling);
        return new Double(myformat.format(doubleData));
    }

    /**
     * Double 转字符串
     * 为null返回空字符串
     *
     * @return String
     * @throws Exception
     * @应用
     */
    public static String DoubleToString(Double doubleData, Integer count) {
        if (doubleData == null) {
            return "";
        }
        DecimalFormat myformat = initDecimalFormat(count);
        return myformat.format(doubleData);
    }

    public static String DoubleToString(Double doubleData, Integer count, boolean buling) {
        if (doubleData == null) {
            return "";
        }
        DecimalFormat myformat = initDecimalFormat(count, buling);
        return myformat.format(doubleData);
    }

    /**
     * String类型转Double
     * 如果为null或者是为空，返回null
     *
     * @param count
     * @return
     */
    public static Double StringToDouble(String str, Integer count) {
        if (StringUtils.isBlank(str) || "null".equals(str)) {
            return null;
        }
        Double dbl = null;
        try {
            DecimalFormat myformat = initDecimalFormat(count);
            dbl = Double.valueOf(myformat.parse(str).doubleValue());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return dbl;
    }

    public static Object getMapKeyByValue(Map map, String value) {
        Set set = map.entrySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            if (entry.getValue().equals(value)) {
                Object s = entry.getKey();
                return s;
            }
        }
        return null;
    }

    /**
     * 通过全大写属性获取XML实际的属性字符串
     *
     * @param root
     * @param str
     * @return
     */
    public static String getActualStr(Element root, String str) {
        if (root != null && StringUtils.isNotBlank(str)) {
            String rootStr = root.asXML();
            int idx = StringUtils.indexOfIgnoreCase(rootStr, "DATANAME=\"" + str + "\"");
            if (idx != -1) {
                return StringUtils.substring(rootStr, idx + 10, idx + 10 + str.length());
            }
        }
        return "";
    }

    /**
     * 指定要在ftl页面使用的静态包名
     * @param packageName
     * @return
     */
    public static TemplateHashModel useStaticPackage(String packageName) {
        try {
            BeansWrapper wrapper = new BeansWrapper(Configuration.VERSION_2_3_26);
            TemplateHashModel staticModels = wrapper.getStaticModels();
            TemplateHashModel fileStatics = (TemplateHashModel) staticModels.get(packageName);
            return fileStatics;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }

    /**
     * 利用freemarker来处理字符串中变量的配置赋值
     *
     * @param input
     * @param templateStr
     * @return
     */
    public static String freemarkerProcess(Map input, String templateStr) {
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        String template = "content";
        stringLoader.putTemplate(template, templateStr);
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_26);
        cfg.setTemplateLoader(stringLoader);
        try {
            Template templateCon = cfg.getTemplate(template);
            StringWriter writer = new StringWriter();
            templateCon.process(input, writer);
            return writer.toString();
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        } catch (TemplateException e) {
            log.error(e.getMessage(), e);
        }
        return null;
    }

    /**
     * 中文数字转阿拉伯数
     * @param chineseNumber
     * @param attachNum 占位补0
     * @return
     */
    public static String chineseNumber2IntStr(String chineseNumber, int attachNum) {
        if (StringUtils.isBlank(chineseNumber)) {
            return "";
        }

        //判断是否包含数字或者中文数字
        boolean isOk = false;
        boolean isNum = false;
        int begin = 0;
        if (StringUtils.contains(chineseNumber, "村")) {
            begin = StringUtils.indexOf(chineseNumber, "村");
        }
        String tmp = "一,二,三,四,五,六,七,八,九,十";
        for (int i = begin, j = chineseNumber.length(); i < j; i++) {
            char c = chineseNumber.charAt(i);
            if ((c >= '0' && c <= '9')) {
                isOk = true;
                isNum = true;
                begin = i;
                break;
            }
            if (StringUtils.contains(tmp, c)) {
                isOk = true;
                begin = i;
                break;
            }
        }
        if (!isOk) {
            return chineseNumber;
        }

        tmp = "一,二,三,四,五,六,七,八,九,十,百,千,万,亿";
        String tmpStr = "";
        for (int i = begin, j = chineseNumber.length(); i < j; i++) {
            char c = chineseNumber.charAt(i);
            if (isNum) {
                if (c >= '0' && c <= '9') {
                    tmpStr += c;
                } else {
                    break;
                }
            } else {
                if (StringUtils.contains(tmp, c)) {
                    tmpStr += c;
                } else {
                    break;
                }
            }
        }
        chineseNumber = tmpStr;
        if (isNum) {
            if (attachNum > chineseNumber.length()) {
                for (int i = 0, j = attachNum - chineseNumber.length(); i < j; i++) {
                    chineseNumber = "0" + chineseNumber;
                }
            }
            return chineseNumber;
        }

        int result = 0;
        int temp = 1;//存放一个单位的数字如：十万
        int count = 0;//判断是否有chArr
        char[] cnArr = new char[]{'一','二','三','四','五','六','七','八','九'};
        char[] chArr = new char[]{'十','百','千','万','亿'};
        for (int i = 0; i < chineseNumber.length(); i++) {
            boolean b = true;//判断是否是chArr
            char c = chineseNumber.charAt(i);
            for (int j = 0; j < cnArr.length; j++) {//非单位，即数字
                if (c == cnArr[j]) {
                    if(0 != count){//添加下一个单位之前，先把上一个单位值添加到结果中
                        result += temp;
                        temp = 1;
                        count = 0;
                    }
                    // 下标+1，就是对应的值
                    temp = j + 1;
                    b = false;
                    break;
                }
            }
            if(b){//单位{'十','百','千','万','亿'}
                for (int j = 0; j < chArr.length; j++) {
                    if (c == chArr[j]) {
                        switch (j) {
                            case 0:
                                temp *= 10;
                                break;
                            case 1:
                                temp *= 100;
                                break;
                            case 2:
                                temp *= 1000;
                                break;
                            case 3:
                                temp *= 10000;
                                break;
                            case 4:
                                temp *= 100000000;
                                break;
                            default:
                                break;
                        }
                        count++;
                    }
                }
            }
            if (i == chineseNumber.length() - 1) {//遍历到最后一个字符
                result += temp;
            }
        }
        chineseNumber = result + "";
        if (attachNum > chineseNumber.length()) {
            for (int i = 0, j = attachNum - chineseNumber.length(); i < j; i++) {
                chineseNumber = "0" + chineseNumber;
            }
        }
        return chineseNumber;
    }
    /**
     * 获取工程绝对路径
     *
     * @return
     */
    public static String getProjectPath() {
        String path = new CommonUtil().getClass().getResource("/").getPath();
        path = StringUtils.substring(path, 1, StringUtils.indexOf(path, "WEB-INF"));
        return path;
    }
}
