package com.gtis.oa.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Receive;
import com.gtis.oa.mapper.ReceiveMapper;
import com.gtis.oa.model.page.ReceivePage;
import com.gtis.oa.service.ReceiveService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 收文 服务实现类
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-08
 */
@Service
public class ReceiveServiceImpl extends ServiceImpl<ReceiveMapper, Receive> implements ReceiveService {

    @Autowired
    ReceiveMapper receiveMapper;

    @Override
    public Receive findByMap(HashMap map){
        return receiveMapper.findByMap(map);
    }

    @Override
    public IPage<Receive> findByPage(ReceivePage receivePage) {
        return receiveMapper.findByPage(receivePage);
    }

    @Override
    public Object getMaxReceiveNo(Map map) {
        return receiveMapper.getMaxReceiveNo(map);
    }
}
