package com.gtis.oa.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Asset;
import com.gtis.oa.mapper.AssetMapper;
import com.gtis.oa.model.AssetModel;
import com.gtis.oa.model.page.AssetPage;
import com.gtis.oa.service.AssetAttachmentService;
import com.gtis.oa.service.AssetService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;

/**
 * <p>
 * 固定资产 服务实现类
 * </p>
 *
 * @author jiangtong
 * @since 2019-07-15
 */
@Service
public class AssetServiceImpl extends ServiceImpl<AssetMapper, Asset> implements AssetService {

    @Autowired
    AssetMapper assetMapper;
    @Autowired
    AssetService assetService;
    @Autowired
    AssetAttachmentService assetAttachmentService;

    @Override
    public Asset findByMap(HashMap map){
        return assetMapper.findByMap(map);
    }

    @Override
    public IPage<Object> findByPage(AssetPage assetPage){
        return assetMapper.findByPage(assetPage);
    }

    /**
     * 保存
     * @param assetModel
     */
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void saveAsset(AssetModel assetModel){
        if (assetModel != null) {
            Asset asset = assetService.getById(assetModel.getId());
            if (asset != null) {
                asset.setApplyUnit(assetModel.getApplyUnit());
                asset.setApplyPeople(assetModel.getApplyPeople());
                asset.setApplyTime(assetModel.getApplyTime());
                asset.setReason(assetModel.getReason());
                assetService.updateById(asset);
            }
//            if (CollectionUtils.isNotEmpty(assetModel.getBlSubareaOfferList())) {
//                assetModel.getBlSubareaOfferList().forEach(blSubareaOffer -> {
//                    if (blSubareaOffer != null) {
//                        int result = CommonUtil.bigDecimalToBigDecimal(blSubareaOffer.getOfferArea(), 4).compareTo(BigDecimal.ZERO);
//                        if (!(StringUtils.isBlank(blSubareaOffer.getSubareaName()) && StringUtils.isBlank(blSubareaOffer.getOfferWay()) && result <= 0)) {
//                            if (StringUtils.isBlank(blSubareaOffer.getSubId())) {
//                                blSubareaOffer.setSubId(UUIDUtil.generate());
//                            }
//                            blSubareaOfferService.save(blSubareaOffer);
//                        }
//                    }
//                });
//            }
        }
    }
}
