/*
 * Author: xyang
 *
 * Project: exchange
 *
 * File: ExchangerStatic.java
 *
 * LastModified: 2010-02-22 12:49:02
 *
 * Copyright (c) 2010 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.oa.model.exchange;

import com.gtis.spring.Container;
import org.apache.commons.lang.StringUtils;

import java.util.Properties;

/**
 * 交换系统对接参数
 * @author <a href="mailto:jibo1024@gmail.com">jibo</a>
 * @version V1.0, 2010-2-22
 */
public class ExchangerStatic {
    @Deprecated
    private String exchangerUser;
    @Deprecated
    private String exchangerPass;
    /** 交换系统收文 Web Service Url */
    private String receivalServiceWsdlUrl;
    /** 交换系统发文 Web Service Url */
    private String sendServiceWsdlUrl;
    /** 交换系统服务 Web Service Url接口改变弃用 */
//    private String serviceWsdlUrl;
    /** 局部配置文件 */
    private static Properties props;
    
    /**
     * 根据key获得用户名
     * @param key
     * @return
     */
    public String getExchangerUser(String key) {
        if(!StringUtils.isNotBlank(key) || "0".equals(key)){
            key = "";
        }
        return getLocalConfigString("exchange.exchangerUser" + key);
    }

    /**
     * 根据key获得发文机关
     * @param key
     * @return
     */
    public String getExchangerUnit(String key) {
        if(!StringUtils.isNotBlank(key) || "0".equals(key)){
            key = "";
        }
        System.out.println("发文机关key=============》》" + key);
        System.out.println("发文机关=============》》"+getLocalConfigString("exchange.unitName" + key));
        return getLocalConfigString("exchange.unitName" + key);
    }

    /**
     * 根据key获得用户名
     * @param key
     * @return
     */
    public String getExchangerPass(String key){
        if(!StringUtils.isNotBlank(key) || "0".equals(key)){
            key = "";
        }
        return getLocalConfigString("exchange.exchangerPass" + key);
    }

    /**
     * 根据key获得工作流定义Id
     * @param key
     * @return
     */
    public String getExchangerWorkflowDefinitionId(String key) {
        if(!StringUtils.isNotBlank(key) || "0".equals(key)){
            key = "";
        }
        return getLocalConfigString("exchange.workflowDefinitionId" + key);
    }

    /**
     * 获得局部变量
     * @param configKey
     * @return
     */
    public static String getLocalConfigString(String configKey) {
        if(props == null){
            props = (Properties) Container.getBean("localProperties");
        }
        return new String(props.getProperty(configKey));
    }
    
    @Deprecated
    public String getExchangerUser() {
        return exchangerUser;
    }
    @Deprecated
    public void setExchangerUser(String exchangerUser) {
        this.exchangerUser = exchangerUser;
    }
    @Deprecated
    public String getExchangerPass() {
        return exchangerPass;
    }
    @Deprecated
    public void setExchangerPass(String exchangerPass) {
        this.exchangerPass = exchangerPass;
    }

    public String getReceivalServiceWsdlUrl() {
        return receivalServiceWsdlUrl;
    }
    public void setReceivalServiceWsdlUrl(String receivalServiceWsdlUrl) {
        this.receivalServiceWsdlUrl = receivalServiceWsdlUrl;
    }
    public String getSendServiceWsdlUrl() {
        return sendServiceWsdlUrl;
    }
    public void setSendServiceWsdlUrl(String sendServiceWsdlUrl) {
        this.sendServiceWsdlUrl = sendServiceWsdlUrl;
    }
}
