package com.gtis.oa.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

/**
 * <p>
 * 电话接听
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-15
 */
public class Telephone extends Model<Telephone> {

    private static final long serialVersionUID = 1L;

    /**
     * 电话记录ID
     */
    @TableId(value = "ID", type = IdType.INPUT)
    private String id;

    /**
     * 来电单位
     */
    private String fromUnit;

    /**
     * 来电人姓名
     */
    private String fromName;

    /**
     * 接电人姓名
     */
    private String reciveName;

    /**
     * 来电内容
     */
    private String teleContent;

    /**
     * 备注
     */
    private String remark;

    /**
     * 接电话时间
     */
    private Date telephoneTime;

    /**
     * 是否完结
     */
    private Integer isfinished;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFromUnit() {
        return fromUnit;
    }

    public void setFromUnit(String fromUnit) {
        this.fromUnit = fromUnit;
    }

    public String getFromName() {
        return fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getReciveName() {
        return reciveName;
    }

    public void setReciveName(String reciveName) {
        this.reciveName = reciveName;
    }

    public String getTeleContent() {
        return teleContent;
    }

    public void setTeleContent(String teleContent) {
        this.teleContent = teleContent;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getTelephoneTime() {
        return telephoneTime;
    }

    public void setTelephoneTime(Date telephoneTime) {
        this.telephoneTime = telephoneTime;
    }

    public Integer getIsfinished() {
        return isfinished;
    }

    public void setIsfinished(Integer isfinished) {
        this.isfinished = isfinished;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Telephone{" +
        "id=" + id +
        ", fromUnit=" + fromUnit +
        ", fromName=" + fromName +
        ", reciveName=" + reciveName +
        ", teleContent=" + teleContent +
        ", remark=" + remark +
        ", telephoneTime=" + telephoneTime +
        ", isfinished=" + isfinished +
        "}";
    }
}
