package com.gtis.oa.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import javax.persistence.Basic;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 系统新闻表(通知)
 * </p>
 *
 * @author zhangxignwei
 * @since 2019-06-14
 */
public class News extends Model<News> {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "ID", type = IdType.INPUT)
    private String id;

    /**
     * 标题
     */
    private String newTitle;

    /**
     * 作者
     */
    private String newAuthor;

    /**
     * 新建时间
     */
    private Date newDate;

    /**
     * 摘要
     */
    private String newSummary;

    /**
     * 内容
     */
    @Lob
    @Basic(fetch = FetchType.EAGER)    @JSONField(serialize = false,name = "NEW_CONTENT")
    private String newContent;

    /**
     * 类型，0：新闻，1：通知公告
     */
    private Integer newType;

    /**
     * 图片地址
     */
    private String imageUrl;

    /**
     * 新闻发布者
     */
    private String newPublisher;

    /**
     * 公告等级
     */
    private String grade;

    /**
     * 发布时间
     */
    private Date newUpdateDate;

    /**
     * 接收人
     */
    private String acceptMan;

    /**
     * 新闻发布人Id
     */
    private String newPublisherId;

    /**
     * 发送单位
     */
    private String sendDept;

    @TableField(exist = false)
    private String imageId;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNewTitle() {
        return newTitle;
    }

    public void setNewTitle(String newTitle) {
        this.newTitle = newTitle;
    }

    public String getNewAuthor() {
        return newAuthor;
    }

    public void setNewAuthor(String newAuthor) {
        this.newAuthor = newAuthor;
    }

    public Date getNewDate() {
        return newDate;
    }

    public void setNewDate(Date newDate) {
        this.newDate = newDate;
    }

    public String getNewSummary() {
        return newSummary;
    }

    public void setNewSummary(String newSummary) {
        this.newSummary = newSummary;
    }

    public String getNewContent() {
        return newContent;
    }

    public void setNewContent(String newContent) {
        this.newContent = newContent;
    }

    public Integer getNewType() {
        return newType;
    }

    public void setNewType(Integer newType) {
        this.newType = newType;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getNewPublisher() {
        return newPublisher;
    }

    public void setNewPublisher(String newPublisher) {
        this.newPublisher = newPublisher;
    }

    public String getGrade() {
        return grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public Date getNewUpdateDate() {
        return newUpdateDate;
    }

    public void setNewUpdateDate(Date newUpdateDate) {
        this.newUpdateDate = newUpdateDate;
    }

    public String getAcceptMan() {
        return acceptMan;
    }

    public void setAcceptMan(String acceptMan) {
        this.acceptMan = acceptMan;
    }

    public String getNewPublisherId() {
        return newPublisherId;
    }

    public void setNewPublisherId(String newPublisherId) {
        this.newPublisherId = newPublisherId;
    }

    public String getSendDept() {
        return sendDept;
    }

    public void setSendDept(String sendDept) {
        this.sendDept = sendDept;
    }

    public String getImageId() {
        return imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "News{" +
        "id=" + id +
        ", newTitle=" + newTitle +
        ", newAuthor=" + newAuthor +
        ", newDate=" + newDate +
        ", newSummary=" + newSummary +
        ", newContent=" + newContent +
        ", newType=" + newType +
        ", imageUrl=" + imageUrl +
        ", newPublisher=" + newPublisher +
        ", grade=" + grade +
        ", newUpdateDate=" + newUpdateDate +
        ", acceptMan=" + acceptMan +
        ", newPublisherId=" + newPublisherId +
        ", sendDept=" + sendDept +
        ", imageId=" + imageId +
        "}";
    }
}
