package com.gtis.oa.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

/**
 * <p>
 * 会议室申请
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-04
 */
public class MeetroomApply extends Model<MeetroomApply> {

    private static final long serialVersionUID = 1L;

    /**
     * 会议室申请ID
     */
    @TableId(value = "ID", type = IdType.INPUT)
    private String id;

    /**
     * 开始时间
     */
    private Date beginTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 人数
     */
    private Integer peopleNums;

    /**
     * 申请事由（用途）
     */
    private String purpose;

    /**
     * 申请人姓名
     */
    private String applyPeople;

    /**
     * 申请部门
     */
    private String applyUnit;

    /**
     * 会议室ID
     */
    private String roomId;

    /**
     * 会议室名称
     */
    private String roomName;

    /**
     * 是否批准
     */
    private Integer apprstate;

    /**
     * 会议主题
     */
    private String meetTheme;

    /**
     * 会议室使用时间
     */
    private Date meetDate;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getPeopleNums() {
        return peopleNums;
    }

    public void setPeopleNums(Integer peopleNums) {
        this.peopleNums = peopleNums;
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getApplyPeople() {
        return applyPeople;
    }

    public void setApplyPeople(String applyPeople) {
        this.applyPeople = applyPeople;
    }

    public String getApplyUnit() {
        return applyUnit;
    }

    public void setApplyUnit(String applyUnit) {
        this.applyUnit = applyUnit;
    }

    public String getRoomId() {
        return roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public Integer getApprstate() {
        return apprstate;
    }

    public void setApprstate(Integer apprstate) {
        this.apprstate = apprstate;
    }

    public String getMeetTheme() {
        return meetTheme;
    }

    public void setMeetTheme(String meetTheme) {
        this.meetTheme = meetTheme;
    }

    public Date getMeetDate() {
        return meetDate;
    }

    public void setMeetDate(Date meetDate) {
        this.meetDate = meetDate;
    }

    public String getRoomName() {
        return roomName;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "MeetroomApply{" +
        "id=" + id +
        ", beginTime=" + beginTime +
        ", endTime=" + endTime +
        ", peopleNums=" + peopleNums +
        ", purpose=" + purpose +
        ", applyPeople=" + applyPeople +
        ", applyUnit=" + applyUnit +
        ", roomId=" + roomId +
        ", roomName=" + roomName +
        ", apprstate=" + apprstate +
        ", meetTheme=" + meetTheme +
        ", meetDate=" + meetDate +
        "}";
    }
}
