package com.gtis.oa.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

/**
 * <p>
 * 借款申请
 * </p>
 *
 * @author jiangtong
 * @since 2019-06-27
 */
public class Loan extends Model<Loan> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "ID", type = IdType.INPUT)
    private String id;

    /**
     * 借款原因
     */
    private String purpose;

    /**
     * 借款金额
     */
    private Double loanSum;

    /**
     * 借款人姓名
     */
    private String applyPeople;

    /**
     * 借款科室
     */
    private String applyUnit;

    /**
     * 申请时间
     */
    private Date applyTime;

    /**
     * 拟借款时间
     */
    private Date loanTime;

    /**
     * 是否办结
     */
    private Integer isfinished;

    /**
     * 借款金额（大写）
     */
    private String loanSumBig;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public Double getLoanSum() {
        return loanSum;
    }

    public void setLoanSum(Double loanSum) {
        this.loanSum = loanSum;
    }

    public String getApplyPeople() {
        return applyPeople;
    }

    public void setApplyPeople(String applyPeople) {
        this.applyPeople = applyPeople;
    }

    public String getApplyUnit() {
        return applyUnit;
    }

    public void setApplyUnit(String applyUnit) {
        this.applyUnit = applyUnit;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public Date getLoanTime() {
        return loanTime;
    }

    public void setLoanTime(Date loanTime) {
        this.loanTime = loanTime;
    }

    public Integer getIsfinished() {
        return isfinished;
    }

    public void setIsfinished(Integer isfinished) {
        this.isfinished = isfinished;
    }

    public String getLoanSumBig() {
        return loanSumBig;
    }

    public void setLoanSumBig(String loanSumBig) {
        this.loanSumBig = loanSumBig;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Loan{" +
        "id=" + id +
        ", purpose=" + purpose +
        ", loanSum=" + loanSum +
        ", applyPeople=" + applyPeople +
        ", applyUnit=" + applyUnit +
        ", applyTime=" + applyTime +
        ", loanTime=" + loanTime +
        ", isfinished=" + isfinished +
        ", loanSumBig=" + loanSumBig +
        "}";
    }
}
