package com.gtis.oa.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.News;
import com.gtis.oa.model.page.NewsPage;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 *  系统新闻表(通知) Mapper 接口
 * </p>
 *
 * @author zhangxignwei
 * @since 2019-06-14
 */
public interface NewsMapper extends BaseMapper<News> {

    /**
     * 多条件分页查询
     * @param newsPage 分页参数分装类
     * @return
     */
    public IPage<News> findByPage(@Param("newsPage")NewsPage newsPage);

    /**
     * 根据map里参数查询数据
     * @param map
     * @return
     */
    public News findByMap(HashMap map);

    public List<News> getListByType(HashMap map);
}
