package com.gtis.oa.core;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.exchange.vo.NewExchangeVo;
import com.gtis.exchange.vo.ReceiverVo;
import com.gtis.oa.model.exchange.ExchangeUser;
import com.gtis.oa.model.exchange.ExchangerStatic;
import com.gtis.plat.vo.PfOrganVo;
import org.apache.commons.lang.StringUtils;
import org.dom4j.*;
import org.dom4j.io.SAXReader;
import org.springframework.util.ResourceUtils;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExchangerXmlHelper
{
    public static final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String uploadFileTemplate =  AppConfig.getProperty("egov.conf") + "/exchange/uploalfile_template.xml";


    public static String buildReceiverVoXml(ReceiverVo receiverVo, String key)
    {
        String xml = "";
        try {
            File fileTemplate = ResourceUtils.getFile(uploadFileTemplate);
            SAXReader reader = new SAXReader();
            Document doc = (Document)reader.read(fileTemplate).clone();
            setEleValue(doc,"//电子公文","公文标识", UUIDGenerator.generate());

            if(StringUtils.isNotBlank(receiverVo.getMmdj())){
                setNodeValue(doc, "//秘密等级", receiverVo.getMmdj());
            }else{
                Node btNode = doc.selectSingleNode("//版头");
                Node tmpNode = doc.selectSingleNode("//秘密等级");
                if(tmpNode!=null){
                    Element tempEl= (Element)tmpNode;
                    Element btEl= (Element)btNode;
                    btEl.remove(tmpNode);
                }
            }
            ExchangerStatic exchangerStatic = new ExchangerStatic();
            String unit = exchangerStatic.getExchangerUnit(key);
            if(StringUtils.isNotBlank(unit)){
                setNodeValue(doc, "//发文机关", unit);
            }
            if(StringUtils.isNotBlank(receiverVo.getBmqx()))
                setNodeValue(doc, "//保密期限", receiverVo.getBmqx());
            if(StringUtils.isNotBlank(receiverVo.getJjcd()) ){
                setNodeValue(doc, "//紧急程度", getJjcd(receiverVo.getJjcd()));
            }
            if(StringUtils.isNotBlank(receiverVo.getSenderUnitBH()))
                setEleValue(doc, "//发文字号", "发文机关代字", receiverVo.getSenderUnitBH());
            if(StringUtils.isNotBlank(receiverVo.getSenderYear()))
                setEleValue(doc, "//发文字号", "发文年号", receiverVo.getSenderYear());
            if(StringUtils.isNotBlank(receiverVo.getSenderXh()))
                setEleValue(doc, "//发文字号", "发文序号", receiverVo.getSenderXh());
            setNodeValue(doc, "//发文字号", receiverVo.getSenderUnitBH() + "〔" + receiverVo.getSenderYear() + "〕" + receiverVo.getSenderXh()+"号");
//          setNodeValue(doc, "//签发人", receiverVo.getZtc().toString());
            setNodeValue(doc, "//标题", receiverVo.getTitle());
            if (StringUtils.isNotBlank(receiverVo.getZsjg())) {
                setNodeValue(doc, "//主送机关", receiverVo.getZsjg());
            }
            if (StringUtils.isNotBlank(receiverVo.getSenderOthers()))
                setNodeValue(doc, "//抄送机关", receiverVo.getSenderOthers());
//            if(StringUtils.isNotBlank(receiverVo.getGkfw()) ){
//                setNodeValue(doc,"//公开范围",getGkfw(receiverVo.getGkfw()));
//            }
            if(StringUtils.isNotBlank(CommonUtil.getCurrStrDate()))
                setNodeValue(doc,"//成文日期", CommonUtil.getCurrStrDate());
            if(StringUtils.isNotBlank(CommonUtil.getCurrStrDate()))
                setNodeValue(doc,"//印发日期", CommonUtil.getCurrStrDate());
//            setNodeValue(doc,"//拟件时间", CommonUtil.getCurrTime());

//            if(StringUtils.isNotBlank(receiverVo.getSenderUnitName()) ){
//                setNodeValue(doc,"//发送单位",receiverVo.getSenderUnitName());
//            }
            //签发人
            if (receiverVo.getZtc() != null) {
                for (String key1 : receiverVo.getZtc()) {
                    if(StringUtils.isNotBlank(key1)){
                        setNodeValue(doc, "//签发人", key1);
                    }
                }
            }
            if ((receiverVo.getMainFile() != null) && (receiverVo.getMainFile().length > 0)) {
                setEleValue(doc,"//公文正文","文件名", processFileName(receiverVo.getMainFile()[0]));
                setEleValue(doc,"//公文正文","正文名称", fileName(receiverVo.getMainFile()[0]));
            }
            Element ele;
            if ((receiverVo.getOtherFiles() != null) && (receiverVo.getOtherFiles().size() > 0)) {
                Node root = doc.selectSingleNode("//公文附件");
                ele = (Element)root;
                for (String[] files : receiverVo.getOtherFiles()) {
                    Element fileOther = ele.addElement("附件");
                    fileOther.setAttributeValue("附件类型", fileType(files[0]));
                    fileOther.setAttributeValue("附件文件名", files[0]);
                    fileOther.setAttributeValue("附件名称",fileName( files[0]));
                }
            }
            xml = doc.asXML();
//            xml = xml.replace("<电子公文 公文类别=\"政府\" 公文种类=\"公文\">", "<电子公文 xmlns=\"http://egs.org.cn/eGovDoc\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://egs.org.cn/eGovDoc http://www.ezepf.com/egov/schema/egov-doc.xsd\" 公文标识=\"AAAAAAAAA-0000-11\" 版本号=\"1.0\" 公文类别=\"政府\" 公文种类=\"公文\">");
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(xml);
        return xml;
    }
    private static String processFileName(String fileName){
        String resultFileName="";
        if(fileName.indexOf(".doc")>-1&&fileName.endsWith("ceb")){
            resultFileName = fileName.substring(0,fileName.indexOf(".doc"));
            resultFileName = resultFileName+".ceb";
        }else{
            resultFileName= fileName;
        }
        return resultFileName;
    }

    private static String fileName(String fileName){
        String resultFileName="";
        if(fileName.lastIndexOf(".")>-1){
            resultFileName = fileName.substring(0,fileName.lastIndexOf("."));
        }else{
            resultFileName= fileName;
        }
        return resultFileName;
    }

    private static String fileType(String fileName){
        String fileType="";
        if(fileName.lastIndexOf(".")>-1){
            fileType = fileName.substring(fileName.lastIndexOf("."),fileName.length());
        }
        return fileType;
    }
    public static ExchangeUser getExchangeUserVo(String userXml) {
        ExchangeUser userVo = new ExchangeUser();
        try {
            if ((userXml != null) && (!userXml.equals(""))) {
                Document doc = DocumentHelper.parseText(userXml);
                Node root = doc.getRootElement();
                userVo.setUnitName(getNodeValue(root, "//unit", "name"));
                userVo.setUnitId(getNodeValue(root, "//unit", "unitid"));
                userVo.setUnitNumber(getNodeValue(root, "//unit", "number"));
                userVo.setUserName(getNodeValue(root, "//user", "name"));
                userVo.setEmpId(getNodeValue(root, "//emp", "empId"));
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return userVo;
    }

    public static List<NewExchangeVo> getExchangeList(String exchangeXml)
    {
        List lstResult = new ArrayList();
        try {
            if ((exchangeXml != null) && (!exchangeXml.equals(""))) {
                Document doc = DocumentHelper.parseText(exchangeXml);
                Node fieldNode=doc.selectSingleNode("//form/fields");
                if(fieldNode!=null){
                    Element fieldEle=(Element)fieldNode;
                    String fieldColumn=fieldEle.attributeValue("column");
                    List dataNode = doc.selectNodes("//form/data");
                    String recordCount="0";
                    if(dataNode!=null && dataNode.size()>0){
                        Element dataEle=(Element)dataNode.get(0);
                        recordCount=dataEle.attributeValue("allRows");

                    }
                    if(StringUtils.isNotBlank(fieldColumn)) {
                        String[] fields=fieldColumn.split(",");
                        if(fields!=null){
                            List dataNodeList = doc.selectNodes("//form/data/row");
                            for (int i = 0; i < dataNodeList.size(); i++) {
                                Element dataEle = (Element)dataNodeList.get(i);
                                NewExchangeVo newExchangeVo=getExchangeVo(dataEle,fields);
                                newExchangeVo.setRecordCount(recordCount);
                                lstResult.add(newExchangeVo);
                            }
                        }
                    }
                }

            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return lstResult;
    }

    public static NewExchangeVo getExchangeVo(Element dataEle, String[] fields) {
        NewExchangeVo vo = new NewExchangeVo();

        String fieldColumn=dataEle.attributeValue("value");
        vo.setTaskId(getEleValue(fieldColumn, 0));
        vo.setStatus(getEleValue(fieldColumn, 1));
        vo.setTitle(getEleValue(fieldColumn, 2));
        vo.setDataType(getEleValue(fieldColumn, 3));
        vo.setSendUnit(getEleValue(fieldColumn, 4));
        vo.setSender(getEleValue(fieldColumn,5));

        try {
            if(StringUtils.isNotBlank(getEleValue(fieldColumn, 6)))
                vo.setSendTime(timeFormat.parse(getEleValue(fieldColumn, 6)));
            if(StringUtils.isNotBlank(getEleValue(fieldColumn, 7)))
                vo.setReceiveTime(timeFormat.parse(getEleValue(fieldColumn, 7)));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        vo.setReceiveIdentity(getEleValue(fieldColumn, 8));
        vo.setReceiveStatus(getEleValue(fieldColumn, 9));
        vo.setRefuseStatus(getEleValue(fieldColumn, 10));
        vo.setBackStatus(getEleValue(fieldColumn, 11));
        vo.setUserId(getEleValue(fieldColumn, 12));
        vo.setIdent(getEleValue(fieldColumn,13));
        vo.setRecordCount("0");
        return vo;
    }

    public static ReceiverVo getReceiverVo(String xml) {
        ReceiverVo resultVo = new ReceiverVo();
        try {
            if (StringUtils.isNotBlank(xml)) {
                Document doc = DocumentHelper.parseText(xml);
                Node root = doc.getRootElement();
                resultVo.setJjcd(getJjcd(getEleValue(root, "//form/data/obj[@name='紧急程度']")));
                resultVo.setSenderUnitName(getEleValue(root, "//form/data/obj[@name='发送单位']"));
                resultVo.setSenderUnitBH(getEleValue(root, "//form/data/obj[@name='公文编号']"));
                resultVo.setSenderYear(getEleValue(root, "//form/data/obj[@name='年']"));
                resultVo.setSenderXh(getEleValue(root, "//form/data/obj[@name='号']"));
                resultVo.setGkfw(getGkfw(getEleValue(root, "//form/data/obj[@name='公开范围']")));
                resultVo.setTitle(getEleValue(root, "//form/data/obj[@name='公文标题']"));
                resultVo.setZsjg(getEleValue(root, "//form/data/obj[@name='主送']"));
                resultVo.setSenderOthers(getEleValue(root, "//form/data/obj[@name='抄送']"));
                List<String> ztc= new ArrayList<String>();
                ztc.add(getEleValue(root, "//form/data/obj[@name='主题词']"));
                resultVo.setZtc(ztc);
                String[] mainFile = new String[2];
                String fileName=getEleValue(root, "//form/data/obj[@name='正文内容']");
                if(StringUtils.indexOf(fileName,".doc")>-1){
                    fileName=StringUtils.substring(fileName,0,StringUtils.indexOf(fileName,".doc"));
                    mainFile[1] = fileName+".ceb";
                    if(StringUtils.isNotBlank(mainFile[1]))
                        mainFile[1]=mainFile[1].replaceAll("\\\\","/");
                    mainFile[0] =  getEleValue(root, "//form/data/obj[@name='公文标题']")+".ceb";
                }else if(StringUtils.indexOf(fileName,".docx")>-1){
                    fileName=StringUtils.substring(fileName,0,StringUtils.indexOf(fileName,".docx"));
                    mainFile[1] = fileName+".ceb";
                    if(StringUtils.isNotBlank(mainFile[1]))
                        mainFile[1]=mainFile[1].replaceAll("\\\\","/");
                    mainFile[0] =  getEleValue(root, "//form/data/obj[@name='公文标题']")+".ceb";
                }else if(StringUtils.indexOf(fileName,".ceb")>-1){
                    mainFile[1] = fileName;
                    if(StringUtils.isNotBlank(mainFile[1]))
                        mainFile[1]=mainFile[1].replaceAll("\\\\","/");
                    mainFile[0] =  getEleValue(root, "//form/data/obj[@name='公文标题']")+".ceb";
                }else if(StringUtils.indexOf(fileName,".pdf")>-1){
                    fileName=StringUtils.substring(fileName,0,StringUtils.indexOf(fileName,".pdf"));
                    mainFile[1] = fileName+".pdf";
                    if(StringUtils.isNotBlank(mainFile[1]))
                        mainFile[1]=mainFile[1].replaceAll("\\\\","/");
                    mainFile[0] =  getEleValue(root, "//form/data/obj[@name='公文标题']")+".pdf";
                }else{
                    mainFile[1] = fileName+".ceb";
                    if(StringUtils.isNotBlank(mainFile[1]))
                        mainFile[1]=mainFile[1].replaceAll("\\\\","/");
                    mainFile[0] =  getEleValue(root, "//form/data/obj[@name='公文标题']")+".ceb";
                }
                resultVo.setMainFile(mainFile);

                List otherFiles = new ArrayList();
                List fileList = doc.selectNodes("//form/attachment/attach");
                for (int i = 0; i < fileList.size(); i++) {
                    Element dataNode = (Element)fileList.get(i);
                    String[] fileInfo = new String[2];
                    fileInfo[0] = dataNode.attributeValue("filename");
                    fileInfo[1] = dataNode.attributeValue("realpath");
                    if(StringUtils.isNotBlank(fileInfo[1]))
                        fileInfo[1]=fileInfo[1].replaceAll("\\\\","/");
                    otherFiles.add(fileInfo);
                }
                resultVo.setOtherFiles(otherFiles);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultVo;
    }

    private static String replaceXmlHeader(String xml) {
        String regEx = "<电子公文.+>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(xml);
        return m.replaceAll("<电子公文>");
    }

    public static String getNodePathValue(Node dataNode, String path) {
        String result = "";
        if (dataNode != null) {
            Map map = new HashMap();
            map.put("design", "http://egs.org.cn/eGovDoc");

            XPath x = dataNode.createXPath(path);
            x.setNamespaceURIs(map);

            Node tmpNode = x.selectSingleNode(dataNode);
            if (tmpNode != null)
                result = tmpNode.getText();
        }
        return result;
    }

    public static void setNodeValue(Node dataNode, String path, String value) {
        if (dataNode != null) {
            Node tmpNode = dataNode.selectSingleNode(path);

            if (tmpNode != null)
                if (value == null)
                    tmpNode.setText("");
                else
                    tmpNode.setText(value.trim());
        }
    }

    public static void setNodeValue(Node dataNode, String path, String arrName, String value)
    {
        if (dataNode != null) {
            Node tmpNode = dataNode.selectSingleNode(path);

            if (tmpNode != null) {
                Element ele = (Element)tmpNode;
                if (value == null)
                    ele.setAttributeValue(arrName, "");
                else
                    ele.setAttributeValue(arrName, value.trim());
            }
        }
    }


    public static String getEleValue(String dataEle, int index) {
        String result = "";
        if (dataEle != null) {
            String[] dataValues=dataEle.split("],");
            if (dataValues != null && index<=dataValues.length) {
                if(StringUtils.indexOf(dataValues[index],"[")==0)
                    result = dataValues[index].substring(1,dataValues[index].length());
                else
                    result = dataValues[index];
            }

        }
        return result;
    }


    public static String getNodeValue(Node dataNode, String path) {
        String result = "";
        if (dataNode != null) {
            Node tmpNode = dataNode.selectSingleNode(path);

            if (tmpNode != null)
                result = tmpNode.getText();
        }
        return result;
    }

    public static String getNodeValue(Node dataNode, String path, String arrName) {
        String result = "";
        if (dataNode != null) {
            Node tmpNode = dataNode.selectSingleNode(path);

            if (tmpNode != null)
                result = tmpNode.valueOf(new StringBuilder().append("@").append(arrName).toString());
        }
        return result;
    }

    public static String getEleValue(Node dataNode, String path, String arrName) {
        String result = "";
        if (dataNode != null) {
            Node tmpNode = dataNode.selectSingleNode(path);

            if (tmpNode != null)
                result = tmpNode.valueOf(new StringBuilder().append("@").append(arrName).toString());
        }
        return result;
    }

    public static String getEleValue(Node dataNode, String path) {
        String result = "";
        if (dataNode != null) {
            Node tmpNode = dataNode.selectSingleNode(path);

            if (tmpNode != null) {
                Element tmpEle=(Element)tmpNode;
                result = tmpEle.attributeValue("value");
            }

        }
        return result;
    }

    public static String getJjcd(String jjcd){
        String jjcd1="";
        if(StringUtils.equals(jjcd,"特急"))
            jjcd1= "特急";
        else if(StringUtils.equals(jjcd,"加急"))
            jjcd1= "加急";
        else
            jjcd1= "平急";
        return jjcd1;
    }

    public static String getGkfw(String gkfw){
        String gkfw1="";
        if(StringUtils.equals(gkfw,"2"))
            gkfw1= "不公开";
        else if(StringUtils.equals(gkfw,"1"))
            gkfw1= "内网公开";
        else
            gkfw1= "内外网公开";
        return gkfw1;
    }


    public static void setEleValue(Node dataNode, String path, String name, String value) {
        if (dataNode != null) {
            Node tmpNode = dataNode.selectSingleNode(path);

            if (tmpNode != null)  {
                Element tmpEle=(Element)tmpNode;

                if (value == null)
                    tmpEle.setAttributeValue(name,"");
                else
                    tmpEle.setAttributeValue(name, value.trim());
            }
        }
    }

    /**
     * 解析组织机构列表XML
     * @param str
     * @return
     * @throws DocumentException
     * @throws IOException
     */
    public static List<PfOrganVo> getListXML(String str) throws DocumentException,
            IOException {
        List<PfOrganVo> pfOrganVoItems = new ArrayList<PfOrganVo>();
        StringReader sr = new StringReader(str);
        SAXReader saxReader = new SAXReader();
        Document doc = saxReader.read(sr);
        Element root = doc.getRootElement();
        List parentNode = root.selectNodes("obj");
        if (parentNode != null && parentNode.size() > 0) {
            for (int i = 0; i < parentNode.size(); i++) {
                Node node = (Node) parentNode.get(i);
                if (node != null) {
                    PfOrganVo pfOrganVo = new PfOrganVo();
                    Element tmpEle = (Element) node;
                    pfOrganVo.setOrganId(tmpEle.attributeValue("id"));
                    pfOrganVo.setOrganName(tmpEle.attributeValue("value"));
                    pfOrganVo.setRemark("1级标题");
                    pfOrganVo.setOraganNo(i+"");
                    pfOrganVo.setRegionCode(i+"");
                    pfOrganVoItems.add(pfOrganVo);
                    List parentNode2 = node.selectNodes("obj");
                    for (int j = 0; j < parentNode2.size(); j++) {
                        Node node2 = (Node) parentNode2.get(j);
                        if (node2 != null) {
                            PfOrganVo pfOrganVo1 = new PfOrganVo();
                            Element tmpEle2 = (Element) node2;
                            pfOrganVo1.setOrganId(tmpEle2.attributeValue("id"));
                            pfOrganVo1.setOrganName(tmpEle2.attributeValue("value"));
                            pfOrganVo1.setRemark("2级标题");
                            pfOrganVo1.setOraganNo(i+"");
                            pfOrganVo1.setRegionCode(j+"");
                            pfOrganVoItems.add(pfOrganVo1);
                            List parentNode3 = node2.selectNodes("obj");
                            for (int k = 0; k < parentNode3.size(); k++) {
                                Node node3 = (Node) parentNode3.get(k);
                                if (node3 != null) {
                                    PfOrganVo pfOrganVo2 = new PfOrganVo();
                                    Element tmpEle3 = (Element) node3;
                                    pfOrganVo2.setOrganId(tmpEle3.attributeValue("id"));
                                    pfOrganVo2.setOrganName(tmpEle3.attributeValue("value"));
                                    pfOrganVo2.setRemark("3级标题");
                                    pfOrganVo2.setOraganNo(j+"");
                                    pfOrganVo2.setRegionCode(k+"");
                                    pfOrganVo2.setSuperOrganId(i+"");
                                    pfOrganVoItems.add(pfOrganVo2);
                                    List parentNode4 = node3.selectNodes("obj");
                                    for (int q = 0; q < parentNode4.size(); q++) {
                                        Node node4 = (Node) parentNode4.get(q);
                                        if (node4 != null) {
                                            PfOrganVo pfOrganVo4 = new PfOrganVo();
                                            Element tmpEle4 = (Element) node4;
                                            pfOrganVo4.setOrganId(tmpEle4.attributeValue("id"));
                                            pfOrganVo4.setOrganName(tmpEle4.attributeValue("value"));
                                            pfOrganVo4.setRemark("4级标题");
                                            pfOrganVo4.setOraganNo(k+"");
                                            pfOrganVo4.setRegionCode(q+"");
                                            pfOrganVo4.setSuperOrganId(j+"");
                                            pfOrganVoItems.add(pfOrganVo4);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return pfOrganVoItems;
    }


//    public static String fXmltoList() {
//        String xmlTemp="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
//                "<form id=\"\" name=\"\" errorcode=\"0\" msg=\"\">\n" +
//                "\t<obj id=\"125\" value=\"江苏省国土资源厅\">\n" +
//                "\t\t<obj id=\"401\" value=\"市县国土资源局\">\n" +
//                "\t\t\t<obj id=\"403\" value=\"南京市国土资源局\">\n" +
//                "\t\t\t\t<obj id=\"416\" value=\"南京市国土资源局玄武分局\" />\n" +
//                "\t\t\t\t<obj id=\"417\" value=\"南京市国土资源局建邺分局\" />\n" +
//                "\t\t\t\t<obj id=\"418\" value=\"南京市国土资源局鼓楼分局\" />\n" +
//                "\t\t\t\t<obj id=\"419\" value=\"南京市国土资源局秦淮分局\" />\n" +
//                "\t\t\t</obj>\n" +
//                "\t\t\t<obj id=\"404\" value=\"无锡市国土资源局\">\n" +
//                "\t\t\t\t<obj id=\"426\" value=\"无锡市国土资源局锡山分局\" />\n" +
//                "\t\t\t\t<obj id=\"427\" value=\"无锡市国土资源局惠山分局\" />\n" +
//                "\t\t\t\t<obj id=\"428\" value=\"无锡市国土资源局滨湖分局\" />\n" +
//                "\t\t\t\t<obj id=\"429\" value=\"无锡市国土资源局新区分局\" />\n" +
//                "\t\t\t</obj>\n" +
//                "\t\t\t<obj id=\"405\" value=\"徐州市国土资源局\">\n" +
//                "\t\t\t\t<obj id=\"432\" value=\"徐州市国土资源局鼓楼分局\" />\n" +
//                "\t\t\t\t<obj id=\"433\" value=\"徐州市国土资源局云龙分局\" />\n" +
//                "\t\t\t\t<obj id=\"434\" value=\"徐州市贾汪区国土资源局\" />\n" +
//                "\t\t\t\t<obj id=\"435\" value=\"徐州市国土资源局泉山分局\" />\n" +
//                "\t\t\t</obj>\n" +
//                "\t\t\t<obj id=\"406\" value=\"常州市国土资源局\">\n" +
//                "\t\t\t\t<obj id=\"445\" value=\"常州市国土资源局天宁分局\" />\n" +
//                "\t\t\t\t<obj id=\"446\" value=\"常州市国土资源局钟楼分局\" />\n" +
//                "\t\t\t\t<obj id=\"447\" value=\"常州市国土资源局戚墅堰分局\" />\n" +
//                "\t\t\t</obj>\n" +
//                "\t\t</obj>\n" +
//                "\t\t<obj id=\"402\" value=\"厅直属事业单位\">\n" +
//                "\t\t\t<obj id=\"526\" value=\"江苏省地质调查研究院\" />\n" +
//                "\t\t\t<obj id=\"527\" value=\"江苏省土地勘测规划院\" />\n" +
//                "\t\t\t<obj id=\"528\" value=\"江苏省地产发展中心\" />\n" +
//                "\t\t</obj>\n" +
//                "\t</obj>\n" +
//                "</form>";
//
//        return xmlTemp;
//    }
//    public static void main(String[] args) {
//        String xmlTemp = fXmltoList();
//        try {
//            getXmlRoot(xmlTemp);
//
//        } catch (DocumentException e) {
//            e.printStackTrace();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//    }

    public static List<NewExchangeVo> getSendList(String exchangeXml)
    {
        List lstResult = new ArrayList();
        try {
            if ((exchangeXml != null) && (!exchangeXml.equals(""))) {
                Document doc = DocumentHelper.parseText(exchangeXml);
                Node fieldNode=doc.selectSingleNode("//form/fields");
                if(fieldNode!=null){
                    Element fieldEle=(Element)fieldNode;
                    String fieldColumn=fieldEle.attributeValue("column");
                    List dataNode = doc.selectNodes("//form/data");
                    String recordCount="0";
                    if(dataNode!=null && dataNode.size()>0){
                        Element dataEle=(Element)dataNode.get(0);
                        recordCount=dataEle.attributeValue("allRows");

                    }
                    if(StringUtils.isNotBlank(fieldColumn)) {
                        String[] fields=fieldColumn.split(",");
                        if(fields!=null){
                            List dataNodeList = doc.selectNodes("//form/data/row");
                            for (int i = 0; i < dataNodeList.size(); i++) {
                                Element dataEle = (Element)dataNodeList.get(i);
                                NewExchangeVo newExchangeVo=getSendVo(dataEle,fields);
                                newExchangeVo.setRecordCount(recordCount);
                                lstResult.add(newExchangeVo);
                            }
                        }
                    }
                }

            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return lstResult;
    }
    public static NewExchangeVo getSendVo(Element dataEle, String[] fields) {
        NewExchangeVo vo = new NewExchangeVo();

        String fieldColumn=dataEle.attributeValue("value");
        vo.setTaskId(getEleValue(fieldColumn, 9));
        vo.setStatus(getEleValue(fieldColumn, 0));
        vo.setTitle(getEleValue(fieldColumn, 1));
        vo.setDataType(getEleValue(fieldColumn, 2));
//        vo.setSendUnit(getEleValue(fieldColumn, 4));
        vo.setSender(getEleValue(fieldColumn,3));

        try {
            if(StringUtils.isNotBlank(getEleValue(fieldColumn, 4)))
                vo.setSendTime(timeFormat.parse(getEleValue(fieldColumn, 4)));
//            if(StringUtils.isNotBlank(getEleValue(fieldColumn, 7)))
//                vo.setReceiveTime(timeFormat.parse(getEleValue(fieldColumn, 7)));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
//        vo.setReceiveIdentity(getEleValue(fieldColumn, 8));
//        vo.setReceiveStatus(getEleValue(fieldColumn, 9));
//        vo.setRefuseStatus(getEleValue(fieldColumn, 10));
//        vo.setBackStatus(getEleValue(fieldColumn, 11));
//        vo.setUserId(getEleValue(fieldColumn, 12));
//        vo.setIdent(getEleValue(fieldColumn,13));
//        vo.setRecordCount("0");
        return vo;
    }

}