package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.SignetUse;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.SignetUsePage;
import com.gtis.oa.service.SignetUseService;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 用章申请表 前端控制器
 * </p>
 *
 * @author jiangtong
 * @since 2019-06-25
 */
@Controller
@RequestMapping("/signetUse")
public class SignetUseController {
    @Autowired
    SignetUseService signetUseService;

    /**
     * 办理单详情编辑页面
     *
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        SignetUse signetUse = null;
        if (StringUtils.isNotBlank(processInsId)) {
            signetUse = signetUseService.getById(processInsId);
        }
        if (signetUse == null){
            signetUse = new SignetUse();
            signetUse.setId(processInsId);
            signetUse.setApplyDate(new Date());
//            signetUse.setPeopleName(CommonUtil.getUser().getUsername());
//            signetUse.setPeopleUnit(CommonUtil.getUser().getOrgRecordList().get(0).getName());
            signetUseService.save(signetUse);
        }
        model.addAttribute("signetUse",signetUse);
        model.addAttribute("view",view);
        return "officeapply/signetUse/signetUse_edit";
    }

    /**
     * 办理单列表
     *
     * @return
     */
    @RequestMapping(value = "/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/signetUse/signetUse_list";
    }

    /**
     * 分页查询
     * @param signetUsePage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(SignetUsePage signetUsePage,long page,long limit) {
        signetUsePage.setCurrent(page);
        signetUsePage.setSize(limit);
        IPage<SignetUse> signetUseIPage = signetUseService.findByPage(signetUsePage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",signetUseIPage.getRecords());
        resultMap.put("count",signetUseIPage.getTotal());
        return resultMap;
    }

    /**
     * 保存
     *
     * @return
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public ResponseMessage<SignetUse> save(SignetUse signetUse) {
        return new ResponseMessage<SignetUse>(signetUseService.saveOrUpdate(signetUse),signetUse);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<SignetUse> delete(String[] ids){
        return new ResponseMessage<>(signetUseService.removeByIds(Arrays.asList(ids)));
    }
}

