package com.gtis.oa.controller;

import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.utilclient.common.client.rest.SignMangerClient;
import cn.gtmap.gtc.utilclient.common.dto.SignDTO;
import com.gtis.common.util.ObjectJSONUtil;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.List;

/**
 * 签名
 * @author zhanggupei
 * @since 2019-07-08
 */
@Controller
@RequestMapping("/sign")
public class SignController {

    @Autowired
    SignMangerClient signMangerClient;

    @Autowired
    StorageClient storageClient;

    /**
     * 签名列表
     * @return
     */
    @RequestMapping("/signList")
    public List<SignDTO> signList(@RequestParam("processInsId") String processInsId,
                                  @RequestParam(value = "signKey", required = false) String signKey,
                                  @RequestParam(value = "username", required = false) String username,
                                  HttpServletResponse response) {
        List<SignDTO> signList = signMangerClient.list(processInsId,signKey,username);
        try{
            response.setContentType("application/json;charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.println(ObjectJSONUtil.ObjectToJson(signList));
            out.flush();
            out.close();
        } catch (Exception e){
            e.printStackTrace();
        }
        return signList;
    }

    /**
     * 保存签名
     * @return
     */
    @RequestMapping("/signSave")
    @ResponseBody
    public String signSave(@RequestParam("processInsId") String processInsId,
                                  @RequestParam(value = "signKey") String signKey,
                                  @RequestParam(value = "signOpinion", required = false) String signOpinion) {
        String msg = "true";
        try{
            signMangerClient.save(processInsId,signKey,signOpinion);
        } catch (Exception e){
            msg = "false";
            e.printStackTrace();
        }
        return msg;
    }

    /**
     * 删除签名
     * @return
     */
    @RequestMapping("/signDel")
    @ResponseBody
    public String signDel(@RequestParam("id") String id) {
        String msg = "true";
        try{
            signMangerClient.delete(id);
        } catch (Exception e){
            msg = "false";
            e.printStackTrace();
        }
        return msg;
    }
}

