package com.gtis.oa.controller;

import cn.gtmap.common.utils.FileUtil;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import cn.gtmap.gtc.workflow.clients.manage.ProcessInstanceClient;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import com.gtis.oa.model.Receive;
import com.gtis.oa.service.ReceiveService;
import com.gtis.oa.util.CalendarUtil;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;

/**
 * <p>
 * 网络收文 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-08-29
 */
@Controller
@RequestMapping("/receiveExchange")
public class ReceiveExchangeController {

    //流程中心
    @Autowired
    ProcessInstanceClient processInstanceClient;
    //文档中心
    @Autowired
    StorageClient storageClient;

    @Autowired
    ReceiveService receiveService;

    private static String rootPath = CommonUtil.getProjectPath();
    /**
     * 网络收文列表
     *
     * @return
     */
    @RequestMapping(value = "/list")
    public String list(){
        return "document/receive/receiveExchange_list";
    }

    /**
     * 跳往编辑页面
     * @return
     */
    @RequestMapping("/createTask")
    public void attachment(String filePath,String taskId,HttpServletRequest request) {
        Receive receive = new Receive();
        String processInsId = "";
        try{
            if(StringUtils.isNotBlank(filePath)){
                File file = new File(filePath);
                File[] tempList = file.listFiles();
                for(int i = 0;i<tempList.length;i++){
                    if (tempList[i].isFile()) {
                        String fileName = tempList[i].getName();
                        if("gongwen.xml".equals(fileName)){
                            SAXReader reader = new SAXReader();
                            Document doc = reader.read(tempList[i]);   ;
                            //获取根节点元素对象
                            Element root = doc.getRootElement();
                            Element gwgsElement = root.element("公文格式");
                            Element btElement = gwgsElement.element("版头");

                            //版头
                            String fh = btElement.elementText("份号");
                            String mmdj = btElement.elementText("秘密等级");
                            String bmqx = btElement.elementText("保密期限");
                            String jjcd = btElement.elementText("紧急程度");
                            String fwjg = btElement.elementText("发文机关");
                            String fwzh = btElement.elementText("发文字号");
                            String fwjgdz = btElement.element("发文字号").attribute("发文机关代字").getValue();
                            String fwnh = btElement.element("发文字号").attribute("发文年号").getValue();
                            String fwxh = btElement.element("发文字号").attribute("发文序号").getValue();
                            String qfr = btElement.elementText("签发人");

                            //主体
                            Element ztElement = gwgsElement.element("主体");
                            String bt = ztElement.elementText("标题");
                            String zsjg = ztElement.elementText("主送机关");
                            String cwrq = ztElement.elementText("成文日期");

                            //版记
                            Element bjElement = gwgsElement.element("版记");
                            String csjg = bjElement.elementText("抄送机关");
                            String yfjg = bjElement.elementText("印发机关");
                            String yfrq = bjElement.elementText("印发日期");

                            //公文正文
                            Element gwzwElement = gwgsElement.element("公文正文");
                            String zwmc = gwzwElement.attribute("正文名称").getValue();
                            String wjm = gwzwElement.attribute("文件名").getValue();

                            //公文附件
                            Element gwfjElement = gwgsElement.element("公文附件");

                            if(StringUtils.isNotBlank(fh)){
                                receive.setPrintNum(fh);
                            }
                            if(StringUtils.isNotBlank(jjcd)){
                                receive.setExigencyDegree(jjcd);
                            }
                            if(StringUtils.isNotBlank(fwjg)){
                                receive.setFromUnit(fwjg);
                            }
                            if(StringUtils.isNotBlank(fwnh)){
                                receive.setReceiveYear(fwnh);
                            }
                            if(StringUtils.isNotBlank(fwxh)){
                                receive.setReceiveNo(Long.valueOf(fwxh));
                            }
                            if(StringUtils.isNotBlank(bt)){
                                receive.setReceiveTitle(bt);
                            }
                            if(StringUtils.isNotBlank(zsjg)){
                                receive.setMainUnit(zsjg);
                            }
                            if(StringUtils.isNotBlank(cwrq)){
                                receive.setReceiveDate(CalendarUtil.formatDate(cwrq));
                            }

                            String processDefKey = "zzWPsfrBnZr8rWM6";
                            String username = CommonUtil.getUser().getUsername();
                            String workDayId = "8d744344-0d4b-4553-8be0-21139ed6dcfa";
                            String processInstanceName = bt;

                            int priority = 0;
                            String category = "officeAut";
                            String department = "8aaa077165a7795e0165acc46ccf0007";
                            int procDueLimt =99;
                            int isPriority = 1;
                            String desc = "desc";
                            TaskData taskData = processInstanceClient.startUpProcess(processDefKey,username,workDayId,processInstanceName,priority,category,department,procDueLimt,isPriority,desc);
                            processInsId = taskData.getProcessInstanceId();

                            receive.setReceiveId(processInsId);
                            receiveService.saveOrUpdate(receive);
                        }else{
                            FileInputStream fileInputStream = new FileInputStream(tempList[i]);
                            MultipartFile multipartFile = new MockMultipartFile(tempList[i].getName(), tempList[i].getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), fileInputStream);
                            System.out.println(multipartFile.getSize());
                            //文档中心
                            MultipartDto multipartDto = new MultipartDto();
                            multipartDto.setData(multipartFile.getBytes());  //文件（request=true）
                            multipartDto.setSpaceCode(processInsId);  //主键（request=true）
                            multipartDto.setClientId("officeAut");  //应用id（request=true）
                            multipartDto.setName(multipartFile.getName());   //文件名（request=true）
                            multipartDto.setSize(multipartFile.getSize());  //大小（request=true）
                            multipartDto.setContentType(multipartFile.getContentType());  //文件类型（request=true）
                            multipartDto.setOriginalFilename(multipartFile.getOriginalFilename());
                            StorageDto storageDto=storageClient.multipartUpload(multipartDto);
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}

