package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Receive;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.ReceivePage;
import com.gtis.oa.service.ReceiveService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.*;

/**
 * <p>
 * 收文 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-08
 */
@Controller
@RequestMapping("/receive")
public class ReceiveController {

    @Autowired
    ReceiveService receiveService;
    /**
     * 跳往编辑页面
     * @return
     */
    @RequestMapping("/index")
    public String index(Model model, String processInsId,String view) {
        Receive receive = null;
        if (StringUtils.isNotBlank(processInsId)) {
            receive = receiveService.getById(processInsId);
        }
        if (receive == null){
            receive = new Receive();
            //processInsId = UUID.hex32();
            receive.setReceiveId(processInsId);
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(Calendar.YEAR);
            receive.setReceiveYear(year + "");
            receive.setReceiveDate(new Date());
            receive.setReplyDate(new Date());
            receiveService.save(receive);
        }
        model.addAttribute("receive",receive);
        model.addAttribute("view",view);
        return "document/receive/receive_edit";
    }

    /**
     * 收文办理管理列表
     *
     * @return
     */
    @RequestMapping(value = "/list")
    public String list(){
        return "document/receive/receive_list";
    }

    /**
     * 收文办理查看列表
     *
     * @return
     */
    @RequestMapping(value = "/viewList")
    public String viewList(){
        return "document/receive/receive_list_view";
    }

    /**
     * 分页查询
     * @param receivePage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(ReceivePage receivePage,long page,long limit) {

        receivePage.setCurrent(page);
        receivePage.setSize(limit);
        IPage<Receive> receiveIPage = receiveService.findByPage(receivePage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",receiveIPage.getRecords());
        resultMap.put("count",receiveIPage.getTotal());
        return resultMap;
    }

    /**
     * 分页查询
     * @param receivePage
     * @return
     */
    @RequestMapping("/findTempByPage")
    @ResponseBody
    public IPage<Receive> findTempByPage(ReceivePage receivePage) {
        IPage<Receive> receiveIPage = receiveService.findByPage(receivePage);
        return receiveIPage;
    }

    /**
     * 保存
     *
     * @return
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public ResponseMessage<Receive> save(Receive receive) {
        return new ResponseMessage<Receive>(receiveService.saveOrUpdate(receive),receive);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Receive> delete(String[] ids){
        return new ResponseMessage<>(receiveService.removeByIds(Arrays.asList(ids)));
    }

    /**
     * 获取收文编号
     *
     * @return
     */
    @RequestMapping(value = "/receiveNo")
    @ResponseBody
    public long receiveNo(String name, String year) {
        long no = 0;
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("receiveName", name);
        map.put("receiveYear", year);
        Object queryNo = receiveService.getMaxReceiveNo(map);
        if (queryNo == null) {
            no = 1;
        } else {
            no = (Long) queryNo;
        }
        return no + 1;
    }
}

