package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Print;
import com.gtis.oa.model.Reimbursement;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.PrintPage;
import com.gtis.oa.service.PrintService;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 印刷申请 前端控制器
 * </p>
 *
 * @author jiangtong
 * @since 2019-06-26
 */
@Controller
@RequestMapping("/print")
public class PrintController {
    @Autowired
    PrintService printService;

    /**
     * 发文办理单详情编辑页面
     *
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        Print print = null;
        if (StringUtils.isNotBlank(processInsId)) {
            print = printService.getById(processInsId);
        }
        if (print == null){
            print = new Print();
            print.setPrintId(processInsId);
            print.setApplyTime(new Date());
            print.setApplyPeople(CommonUtil.getUser().getAlias());
            print.setApplyUnit(CommonUtil.getUser().getOrgRecordList().get(0).getName());
            printService.save(print);
        }
        model.addAttribute("print",print);
        model.addAttribute("view",view);
        return "officeapply/print/print_edit";
    }

    /**
     * 办理单列表
     *
     * @return
     */
    @RequestMapping(value = "/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/print/print_list";
    }

    /**
     * 分页查询
     * @param printPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(PrintPage printPage,long page,long limit) {
        printPage.setCurrent(page);
        printPage.setSize(limit);
        IPage<Print> printIPage = printService.findByPage(printPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",printIPage.getRecords());
        resultMap.put("count",printIPage.getTotal());
        return resultMap;
    }

    /**
     * 保存
     *
     * @return
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public ResponseMessage<Print> save(Print print) {
        return new ResponseMessage<Print>(printService.saveOrUpdate(print),print);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Print> delete(String[] ids){
        return new ResponseMessage<>(printService.removeByIds(Arrays.asList(ids)));
    }
}

