package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Outgoing;
import com.gtis.oa.model.Receive;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.OutgoingPage;
import com.gtis.oa.service.OutgoingService;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.springframework.ui.Model;

/**
 * <p>
 * 出差学习、请假、外出申请表 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-06-20
 */
@Controller
@RequestMapping("/outgoing")
public class OutgoingController {

    @Autowired
    OutgoingService outgoingService;

    /**
     * 跳转数据详情页
     * @param model
     * @param processInsId
     * @param outType
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId, int outType,String view) {
        Outgoing outgoing = null;
        if (StringUtils.isNotBlank(processInsId)) {
            HashMap map = new HashMap();
            map.put("id",processInsId);
            map.put("outType",outType);
            outgoing = outgoingService.findByMap(map);
        }
        if(outgoing == null){
            outgoing = new Outgoing();
            outgoing.setId(processInsId);
            outgoing.setApplyDate(new Date());
            outgoing.setOutType(outType);
            outgoing.setPeopleId(CommonUtil.getUserId());
            outgoing.setPeopleName(CommonUtil.getUser().getAlias());
            outgoing.setPeopleUnit(CommonUtil.getUser().getOrgRecordList().get(0).getName());
        }
        model.addAttribute("outgoing", outgoing);
        model.addAttribute("view",view);
        if(outType==1){
            return "officeapply/outgoing/outgoing_edit";
        } else if(outType==2){
            return "officeapply/outgoing/bussiness_out_edit";
        } else if(outType==3){
            return "officeapply/outgoing/goout_edit";
        } else {
            return null;
        }
    }

    /**
     * 列表页
     * @return
     */
    @RequestMapping("/list")
    public String list(Model model,int outType,String type){
        model.addAttribute("outType",outType);
        model.addAttribute("type",type);
        if(outType==1){
            return "officeapply/outgoing/outgoing_list";
        } else if(outType==2){
            return "officeapply/outgoing/bussiness_out_list";
        } else if(outType==3){
            return "officeapply/outgoing/goout_list";
        } else {
            return null;
        }
    }


    /**
     * 根据查询条件分页查询
     * @param outgoingPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(OutgoingPage outgoingPage,long page,long limit){
        outgoingPage.setCurrent(page);
        outgoingPage.setSize(limit);
        IPage<Outgoing> outgoingIPage = outgoingService.findByPage(outgoingPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",outgoingIPage.getRecords());
        resultMap.put("count",outgoingIPage.getTotal());
        return resultMap;
    }

    /**
     * 更新或新增
     * @param outgoing
     */
    @RequestMapping("/save")
    @ResponseBody
    public ResponseMessage<Outgoing> save(Outgoing outgoing){
        return new ResponseMessage<Outgoing>(outgoingService.saveOrUpdate(outgoing),outgoing);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Outgoing> delete(String[] ids){
        return new ResponseMessage<>(outgoingService.removeByIds(Arrays.asList(ids)));
    }
}

