package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.OfficialReception;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.OfficialReceptionPage;
import com.gtis.oa.service.OfficialReceptionService;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 公务接待申请 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-15
 */
@Controller
@RequestMapping("/officialReception")
public class OfficialReceptionController {

    @Autowired
    OfficialReceptionService officialReceptionService;

    /**
     * 跳转数据详情页
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        OfficialReception officialReception = null;
        if (StringUtils.isNotBlank(processInsId)) {
            officialReception = officialReceptionService.getById(processInsId);
        }
        if(officialReception == null){
            officialReception = new OfficialReception();
            officialReception.setId(processInsId);
            officialReception.setApplyPeople(CommonUtil.getUser().getAlias());
            officialReception.setApplyUnit(CommonUtil.getUser().getOrgRecordList().get(0).getName());
        }
        model.addAttribute("officialReception", officialReception);
        model.addAttribute("view",view);
        return "officeapply/officialReception/officialReception_edit";
    }

    /**
     * 列表页
     * @return
     */
    @RequestMapping("/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/officialReception/officialReception_list";
    }


    /**
     * 根据查询条件分页查询
     * @param officialReceptionPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(OfficialReceptionPage officialReceptionPage, long page, long limit){
        officialReceptionPage.setCurrent(page);
        officialReceptionPage.setSize(limit);
        IPage<OfficialReception> civil = null;
        Map<String,Object> resultMap = new HashMap<>();
        try{
            civil = officialReceptionService.findByPage(officialReceptionPage);
            resultMap.put("code","0");
            resultMap.put("data",civil.getRecords());
            resultMap.put("count",civil.getTotal());
        }catch (Exception e){
            e.printStackTrace();
        }
        return resultMap;
    }

    /**
     * 更新或新增
     * @param officialReception
     */
    @RequestMapping("/save")
    @ResponseBody
    public ResponseMessage<OfficialReception> save(OfficialReception officialReception){
        return new ResponseMessage<OfficialReception>(officialReceptionService.saveOrUpdate(officialReception),officialReception);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<OfficialReception> delete(String[] ids){
        return new ResponseMessage<>(officialReceptionService.removeByIds(Arrays.asList(ids)));
    }
}

