package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.client.NewsClient;
import com.gtis.oa.model.News;
import com.gtis.oa.model.PageDataModel;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.NewsPage;
import com.gtis.oa.service.NewsService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.json.annotations.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * <p>
 *  系统新闻表(通知) 前端控制器
 * </p>
 *
 * @author zhangxignwei
 * @since 2019-06-14
 */
@Controller
@RequestMapping("/news")
@Slf4j
public class NewsController {

    @Autowired
    NewsService newsService;

    /**
     * 跳往编辑页面
     * @return
     */
    @RequestMapping("/index")
    public String index(String id, Model model, int newType,String view){
        News news = null;
        if (StringUtils.isNotBlank(id)) {
            HashMap map = new HashMap();
            map.put("id",id);
            map.put("newType",newType);
            news = newsService.findByMap(map);
        }
        if(news == null){
            news = new News();
            news.setId(id);
            news.setNewDate(new Date());
            news.setNewType(newType);
        }
        model.addAttribute("news", news);
        model.addAttribute("view",view);
        if(newType==0){
            return "management/news/news_edit";
        } else if(newType==1){
            return "management/news/notice_edit";
        } else {
            return null;
        }
    }
    /**
     * 列表页
     * @return
     */
    @RequestMapping("/list")
    public String list(Model model,int newType,String type){
        model.addAttribute("newType",newType);
        if(newType==0){
            if("view".equals(type)){
                return "management/news/news_list_view";
            }else{
                return "management/news/news_list";
            }
        } else if(newType==1){
            if("view".equals(type)){
                return "management/news/notice_list_view";
            }else{
                return "management/news/notice_list";
            }
        } else {
            return null;
        }
    }

    /**
     * 分页查询
     * @param newsPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(NewsPage newsPage,long page,long limit){
        newsPage.setCurrent(page);
        newsPage.setSize(limit);
        IPage<News> newsIPage = newsService.findByPage(newsPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",newsIPage.getRecords());
        resultMap.put("count",newsIPage.getTotal());
        return resultMap;
    }

    /**
     * 查看列表分页查询
     * @param newsPage
     * @return
     */
    @RequestMapping("/findViewByPage")
    @ResponseBody
    public IPage<News> findViewByPage(NewsPage newsPage){
        IPage<News> newsIPage = newsService.findByPage(newsPage);
        return newsIPage;
    }

    /**
     * 更新或新增
     * @param news
     */
    @RequestMapping("/save")
    @ResponseBody
    public ResponseMessage<News> save(News news){
        ResponseMessage<News> a = null;
        News temp = new News();
        String newsId = news.getId();
        try{
            temp = newsService.getById(newsId);
            if(temp ==null){
                a =  new ResponseMessage<News>(newsService.save(news),news);
            } else {
                a = new ResponseMessage<News>(newsService.updateById(news),news);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return a;
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<News> delete(String[] ids){
        return new ResponseMessage<>(newsService.removeByIds(Arrays.asList(ids)));
    }

    /**
     * 获取数据展示在首页
     * @return
     */
    @RequestMapping(value = "/getListByType")
    @ResponseBody
    public String getListByType (HttpServletRequest request){
        List<PageDataModel> list = new ArrayList<PageDataModel>();
        HashMap map = new HashMap();
        int newType = 0;
        map.put("newType",newType);
        List<News> newsList = newsService.getListByType(map);
        for (News aNewsList : newsList) {
            PageDataModel pageDataModel = new PageDataModel();
            pageDataModel.setId(aNewsList.getId());
            pageDataModel.setTitle(aNewsList.getNewTitle());
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
            pageDataModel.setUrl(basePath+"/oa/news/show?id="+aNewsList.getId());
            pageDataModel.setTime(aNewsList.getNewDate());
            list.add(pageDataModel);
        }
        HashMap dataMap = new HashMap();
        dataMap.put("list",list);
        return com.alibaba.fastjson.JSON.toJSONString(dataMap);
    }

    /**
     * 跳转展示页
     * @param model
     * @param id
     * @return
     */
    @RequestMapping(value = "/show")
    public String show(Model model,String id) {
        News news = newsService.getById(id);
        model.addAttribute("news",news);
        return "management/news/news_show";
    }
}

