package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.MessagePublish;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.MessagePublishPage;
import com.gtis.oa.service.MessagePublishService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 政务信息发布 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-06-27
 */
@Controller
@RequestMapping("/messagePublish")
public class MessagePublishController {

    @Autowired
    MessagePublishService messagePublishService;

    /**
     * 跳转数据详情页
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        MessagePublish messagePublish = null;
        if (StringUtils.isNotBlank(processInsId)) {
            messagePublish = messagePublishService.getById(processInsId);
        }
        if(messagePublish == null){
            messagePublish = new MessagePublish();
            messagePublish.setId(processInsId);
        }
        model.addAttribute("messagePublish", messagePublish);
        model.addAttribute("view",view);
        return "officeapply/messagePublish/message_publish_edit";
    }

    /**
     * 列表页
     * @return
     */
    @RequestMapping("/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/messagePublish/message_publish_list";
    }


    /**
     * 根据查询条件分页查询
     * @param messagePublishPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(MessagePublishPage messagePublishPage,long page,long limit){
        messagePublishPage.setCurrent(page);
        messagePublishPage.setSize(limit);
        IPage<MessagePublish> messagePublishIPage = messagePublishService.findByPage(messagePublishPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",messagePublishIPage.getRecords());
        resultMap.put("count",messagePublishIPage.getTotal());
        return resultMap;
    }

    /**
     * 更新或新增
     * @param messagePublish
     */
    @RequestMapping("/save")
    @ResponseBody
    public ResponseMessage<MessagePublish> save(MessagePublish messagePublish){
        return new ResponseMessage<MessagePublish>(messagePublishService.saveOrUpdate(messagePublish),messagePublish);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<MessagePublish> delete(String[] ids){
        return new ResponseMessage<>(messagePublishService.removeByIds(Arrays.asList(ids)));
    }
}

