package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Meetroom;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.MeetroomPage;
import com.gtis.oa.service.MeetroomService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 会议室 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-04
 */
@Controller
@RequestMapping("/meetroom")
public class MeetroomController {

    @Autowired
    MeetroomService meetroomService;
    /**
     * 列表页
     * @return
     */
    @RequestMapping("/list")
    public String list(Model model){
        return "management/meet/meetroom_list";
    }

    /**
     * 根据查询条件分页查询
     * @param meetroomPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(MeetroomPage meetroomPage,long page,long limit){
        meetroomPage.setCurrent(page);
        meetroomPage.setSize(limit);
        IPage<Meetroom> meetroomIPage = meetroomService.findByPage(meetroomPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",meetroomIPage.getRecords());
        resultMap.put("count",meetroomIPage.getTotal());
        return resultMap;
    }

    /**
     * 跳转数据详情页
     * @param model
     * @param roomId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model,String roomId) {
        Meetroom meetroom = null;
        if (StringUtils.isNotBlank(roomId)) {
            meetroom = meetroomService.getById(roomId);
        }
        if(meetroom == null){
            meetroom = new Meetroom();
            meetroom.setRoomId(roomId);
        }
        model.addAttribute("meetroom", meetroom);
        return "management/meet/meetroom_edit";
    }

    /**
     * 更新或新增
     * @param meetroom
     */
    @RequestMapping("/save")
    @ResponseBody
    public ResponseMessage<Meetroom> save(Meetroom meetroom){
        ResponseMessage<Meetroom> a = null;
        try{
            if(StringUtils.isNotBlank(meetroom.getRoomId())){
                a = new ResponseMessage<Meetroom>(meetroomService.updateById(meetroom),meetroom);
            }else{
                meetroom.setRoomId(UUID.hex32());
                a =  new ResponseMessage<Meetroom>(meetroomService.save(meetroom),meetroom);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return a;
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Meetroom> delete(String[] ids){
        return new ResponseMessage<>(meetroomService.removeByIds(Arrays.asList(ids)));
    }

    /**
     * 组织左边导航栏
     * @return
     */
    @RequestMapping("/getParentMeun")
    @ResponseBody
    public List<Meetroom> getParentMeun() {
        MeetroomPage meetroomPage = new MeetroomPage();
        //获取所有的菜单
        IPage<Meetroom> list = meetroomService.findByPage(meetroomPage);
        List<Meetroom> meetroomList = list.getRecords();
        return meetroomList;
    }
}

