package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.MeetingWork;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.MeetingWorkPage;
import com.gtis.oa.service.MeetingWorkService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 会务申请 前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-15
 */
@Controller
@RequestMapping("/meetingWork")
public class MeetingWorkController {

    @Autowired
    MeetingWorkService meetingWorkService;

    /**
     * 跳转数据详情页
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        MeetingWork meetingWork = null;
        if (StringUtils.isNotBlank(processInsId)) {
            meetingWork = meetingWorkService.getById(processInsId);
        }
        if(meetingWork == null){
            meetingWork = new MeetingWork();
            meetingWork.setId(processInsId);
        }
        model.addAttribute("meetingWork", meetingWork);
        model.addAttribute("view",view);
        return "officeapply/meetingwork/meetingwork_edit";
    }

    /**
     * 列表页
     * @return
     */
    @RequestMapping("/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/meetingwork/meetingwork_list";
    }


    /**
     * 根据查询条件分页查询
     * @param meetingWorkPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(MeetingWorkPage meetingWorkPage,long page,long limit){
        meetingWorkPage.setCurrent(page);
        meetingWorkPage.setSize(limit);
        IPage<MeetingWork> meetingWorkIPage = meetingWorkService.findByPage(meetingWorkPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",meetingWorkIPage.getRecords());
        resultMap.put("count",meetingWorkIPage.getTotal());
        return resultMap;
    }

    /**
     * 更新或新增
     * @param meetingWork
     */
    @RequestMapping("/save")
    @ResponseBody
    public ResponseMessage<MeetingWork> save(MeetingWork meetingWork){
        return new ResponseMessage<MeetingWork>(meetingWorkService.saveOrUpdate(meetingWork),meetingWork);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<MeetingWork> delete(String[] ids){
        return new ResponseMessage<>(meetingWorkService.removeByIds(Arrays.asList(ids)));
    }
}

