package com.gtis.oa.controller;

import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import com.gtis.oa.model.Dispatch;
import com.gtis.oa.model.Receive;
import com.gtis.oa.service.DispatchService;
import com.gtis.oa.service.ReceiveService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 归档收发文
 * </p>
 *
 * @author jiangtong
 * @since 2019-08-12
 */
@Slf4j
@Controller
@RequestMapping("/archive")
public class ArchiveController {

    @Autowired
    StorageClient storageClient;
    @Autowired
    DispatchService dispatchService;
    @Autowired
    ReceiveService receiveService;;
    private DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    //发文归档
    @ResponseBody
    @RequestMapping(value = "/dispatch")
    public HashMap dispatch(String[] ids,String clientId){
        HashMap map = new HashMap();
        for (String id : ids) {
            Dispatch dispatch = null;
            dispatch = dispatchService.getById(id);
            List<StorageDto> file = null;
            List<StorageDto> files = new ArrayList<>();
            //获取所有文件夹
            List<StorageDto> folders = storageClient.listAllRootStorages(clientId,dispatch.getDispatchId(),null,null,null,0);
            if (folders != null && !folders.isEmpty()) {
                //遍历文件下的文件
                for (StorageDto folder : folders) {
                    file = storageClient.listAllSubsetStorages(folder.getId(),null, null, 1);
                    files.add(file.get(0));
                }
                StringBuffer stringBuffer = dispatchXml(dispatch,files);
                map = goArchive(stringBuffer);
            }
        }
        return map;
    }

    //组织发文xml
    private StringBuffer dispatchXml (Dispatch dispatch, List<StorageDto> files){
        String wh = dispatch.getDispatchName() + "(" + dispatch.getDispatchYear() + ")" + dispatch.getDispatchNo() + "号";
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<list>\n" +
                "     <archive type=\"Wsda\">");
        sb.append("<field name=\"dh\"></field>");                                                //档案号
        sb.append("<field name=\"wh\">" + wh + "</field>");                    //文号
        //sb.append("<field name=\"rq\">" + strDate(dispatch.getGdrq()) + "</field>");   //制文日期
        sb.append("<field name=\"zrz\"></field>");                                              //责任者
        sb.append("<field name=\"jh\">" + dispatch.getDispatchNo() + "</field>");                                          //件号
        //sb.append("<field name=\"bgqx\">" + dispatch.getBgqx() + "</field>");                                             //保管期限
        sb.append("<field name=\"mj\"></field>");                                         //密级
        sb.append("<field name=\"nd\">" + dispatch.getDispatchYear() + "</field>");             //归档年号
        sb.append("<field name=\"qzh\"></field>");                                              //全宗号
        sb.append("<field name=\"tm\">" + dispatch.getDispatchTitle() + "</field>");              //题名
        sb.append("<field name=\"dwdm\"></field>");                                             //行政区代码
        int j = 0;
        if(files.size()>0){
            for (StorageDto file : files){
                j++;
                sb.append("<file url=\"" + file.getDownUrl() + "\"/>");
            }
        }
        sb.append("</archive>");
        if(files.size()>0){
            for (StorageDto file : files){
                sb.append("<doc>");
                sb.append("<field name=\"tm\">" + file.getName() + "</field>");
                sb.append("<field name=\"sxh\">" + j + "</field>");
                sb.append("<file url=\"" + file.getDownUrl() + "\"/>");
                sb.append("</doc>");
                j++;
            }
        }
        sb.append("</list>");
        return sb;
    }

    //收文归档
    @ResponseBody
    @RequestMapping(value = "/receive")
    public HashMap receive(String[] ids,String clientId){
        HashMap map = new HashMap();
        for (String id : ids) {
            Receive receive = null;
            receive = receiveService.getById(id);
            List<StorageDto> file = null;
            List<StorageDto> files = new ArrayList<>();
            //获取所有文件夹
            List<StorageDto> folders = storageClient.listAllRootStorages(clientId,receive.getReceiveId(),null,null,null,0);
            if (folders != null && !folders.isEmpty()) {
                //遍历文件下的文件
                for (StorageDto folder : folders) {
                    file = storageClient.listAllSubsetStorages(folder.getId(),null, null, 1);
                    files.add(file.get(0));
                }
                StringBuffer stringBuffer = receiveXml(receive,files);
                map = goArchive(stringBuffer);
            }
        }
        return map;
    }

    //组织收文xml
    private StringBuffer receiveXml(Receive receive, List<StorageDto> files) {
        String wh = receive.getReceiveName() + "(" + receive.getReceiveYear() + ")" + receive.getReceiveNo() + "号";
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<list>\n" +
                "     <archive type=\"Wsda\">");
        sb.append("<field name=\"dh\"></field>");                                                //档案号
        sb.append("<field name=\"wh\">" + wh + "</field>");                    //文号
//        sb.append("<field name=\"rq\">" + sdf(receive.getGdrq()) + "</field>");   //制文日期
        sb.append("<field name=\"zrz\">" + receive.getFromUnit() + "</field>");                   //责任者
        sb.append("<field name=\"jh\">" + receive.getReceiveNo() + "</field>");                                          //件号
//        sb.append("<field name=\"bgqx\">" + receive.getBgqx() + "</field>");        //保管期限
        sb.append("<field name=\"mj\"></field>");                                         //密级
        sb.append("<field name=\"nd\">" + receive.getReceiveYear() + "</field>");               //归档年号
        sb.append("<field name=\"qzh\"></field>");                                              //全宗号
        sb.append("<field name=\"tm\">" + receive.getReceiveTitle() + "</field>");                //题名
        sb.append("<field name=\"zlsj\">" + sdf.format(receive.getReplyDate()) + "</field>");        //著录时间
        sb.append("<field name=\"dwdm\"></field>");                                             //
        int j = 0;
        if(files.size()>0){
            for (StorageDto file : files){
                j++;
                sb.append("<file url=\"" + file.getDownUrl() + "\"/>");
            }
        }
        sb.append("</archive>");
        if(files.size()>0){
            for (StorageDto file : files){
                sb.append("<doc>");
                sb.append("<field name=\"tm\">" + file.getName() + "</field>");
                sb.append("<field name=\"sxh\">" + j + "</field>");
                sb.append("<file url=\"" + file.getDownUrl() + "\"/>");
                sb.append("</doc>");
                j++;
            }
        }
        sb.append("</list>");
        return sb;
    }

    //组织数据传输到档案系统 测试http://192.168.90.65:8088/archive/gateway.action
    private HashMap goArchive(StringBuffer stringBuffer){
        HashMap map = new HashMap();
        String msg = "";
        Boolean success = false;
        String url = "";
        HttpClient client = new HttpClient();
        PostMethod postMethod = new PostMethod(url);
        postMethod.addParameter("data", stringBuffer.toString());
        postMethod.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "utf-8");
        try {
            int status = client.executeMethod(postMethod);
            if (HttpStatus.SC_OK == status) {
                success = true;
                msg = "归档成功!";
            } else {
                msg = "请检查" + url + "归档系统地址是否可用";
            }
        } catch (Exception e) {
            msg = "归档失败" + e.getMessage();
            log.error(e.getMessage(), e);
        }
        map.put("msg",msg);
        map.put("success",success);
        return map;
    }

}
