package com.gtis.oa.config;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.TemplateModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;

/**
 * freemarker工具
 * @author zsj
 * @version v1.0, 2018/5/12
 */
@Configuration
public class FreemarkerConfig {

    static Logger logger = LoggerFactory.getLogger(FreemarkerConfig.class);

    @Autowired
    freemarker.template.Configuration configuration;

    @Value("${app.base}")
    private String base;

    @Value("${app.storage}")
    private String storage;

    @PostConstruct
    public void setCfg() {
        try {
            configuration.setSharedVariable("base", base);
            configuration.setSharedVariable("storage", storage);
            configuration.setClassicCompatible(true);
            configuration.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
            configuration.setDateFormat("yyyy-MM-dd");

            configuration.setTimeFormat("HH:mm:ss");
            configuration.setNumberFormat("0.##");
            configuration.setDefaultEncoding("UTF-8");
            configuration.setURLEscapingCharset("UTF-8");

        } catch (TemplateModelException e) {
            e.printStackTrace();
        }
    }


}