package com.gtis.oa.config;

import com.google.common.collect.Sets;
import com.gtis.oa.common.spring.DateToStringConverter;
import com.gtis.oa.common.utils.ConversionService;
import com.gtis.oa.common.utils.StringToDateConverter;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

import java.util.Properties;
import java.util.Set;


/**
 * Bean注册
 * @author zsj
 * @version v1.0, 2018/6/25
 */
@Configuration
public class BeanResolverConfiguer extends WebMvcConfigurerAdapter {



    @Autowired
    SqlSessionTemplate sqlSessionTemplate;


//    @Bean
//    public ConversionService getConversionService() {
//        Set<Converter> converters = Sets.newHashSet();
//        ConversionService conversionService = new ConversionService();
//        converters.add(new DateToStringConverter());
//        converters.add(new StringToDateConverter());
//        conversionService.setConverters(converters);
//        return conversionService;
//    }

    /**
     * 处理ResponseBody异常
     * @return
     */
//    @Bean
//    public ResponseBodyHandlerExceptionResolver getResponseBodyHandlerExceptionResolver() {
//        return new ResponseBodyHandlerExceptionResolver();
//    }

    /**
     * 错误页面处理
     * @return
     */
    @Bean
    public SimpleMappingExceptionResolver getSimpleMappingExceptionResolver() {
        SimpleMappingExceptionResolver simpleMappingExceptionResolver = new SimpleMappingExceptionResolver();
        simpleMappingExceptionResolver.setDefaultErrorView("common/500");
        simpleMappingExceptionResolver.setExceptionAttribute("ex");
        simpleMappingExceptionResolver.setDefaultStatusCode(500);
        Properties statusCodes = new Properties();
        statusCodes.put("common/500", "500");
        statusCodes.put("common/404", "404");
        simpleMappingExceptionResolver.setStatusCodes(statusCodes);
        Properties mappings = new Properties();
        mappings.put("java.lang.Exception", "500");
        simpleMappingExceptionResolver.setExceptionMappings(mappings);
        return simpleMappingExceptionResolver;
    }

//    @Bean
//    public FastjsonHttpMessageConverter getFastjsonHttpMessageConverter() {
//        return new FastjsonHttpMessageConverter();
//    }

    /**
     * Date String 转换
     * @return
     */
    @Bean
    public ConfigurableWebBindingInitializer getConfigurableWebBindingInitializer() {
        ConfigurableWebBindingInitializer configurableWebBindingInitializer = new ConfigurableWebBindingInitializer();
        configurableWebBindingInitializer.setConversionService(getConversionService());
        return configurableWebBindingInitializer;
    }

    @Bean
    public ConversionService getConversionService() {
        Set<Converter> converters = Sets.newHashSet();
        ConversionService conversionService = new ConversionService();
        converters.add(new DateToStringConverter());
        converters.add(new StringToDateConverter());
        conversionService.setConverters(converters);
        return conversionService;
    }


    /**
     * HTTP请求
     * @return
     */
    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

}