<@com.html title="车辆选择列表" import="viewList,list,screen" />
<body class="gtmap">
<@toolbar show="select"/>
<div class="gtmap-body">
    <div class="gtmap-cnt">
        <input type="hidden" id="id" name="id" value="${id!}">
        <div class="menu-group">
            <form class="layui-form gt-form-group gt-form-bdgroup">
                <div class="gt-new-form-item">
                    <div class="right-btnbox">
                        <div class="layui-btn layui-btn-sm">
                            <div onclick="loadInfo()"><i class="iconfont icon-sousuo" ></i>搜索</div>
                        </div>
                    </div>
                    <div class="left-form">
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    车牌号：
                                </div>
                            </label>
                            <div class="layui-input-block ">
                                <input type="text" name="carNo" id="carNo" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    驾驶员：
                                </div>
                            </label>
                            <div class="layui-input-block ">
                                <input type="text" name="driverName" id="driverName" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="tablebox">
            <table class="layui-hide" id="table1" lay-filter="table1"></table>
        </div>
    </div>
</div>
</body>
<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        var tableHeight=initHeight("init");
        window.loadInfo = function(e) {
            table.render({
                elem: '#table1',
                url: '${base}/car/findByPage',
                dataType: "json",
                where: {
                    "carNo": $("#carNo").val(),
                    "driverName": $("#driverName").val()
                },
                height: 'full-' + tableHeight,
                id: 'idTest',
                cols: [[
                    {type: 'radio', fixed: 'left'}
                    , {field: 'carId', title: 'carId', width: '3%', fixed: 'left', hide: true}
                    , {field: 'carNo', title: '车牌号', width: '10%'}
                    , {field: 'driverName', title: '驾驶员', width: '15%'}
                    , {field: 'carType', title: '车型', width: '15%'}
                    , {field: 'peopleNum', title: '可容纳人数', width: '15%'}
                    , {field: 'carCode', title: '状态', width: '15%'}
                    , {field: 'remark', title: '备注', width: '27%'}
                ]],
                page: true
            });
        };

        //初始化查询
        loadInfo();

        //选择提交
        function selected() {
            var checkStatus = table.checkStatus('idTest'),
            carId = checkStatus.data[0].carId;
            $.ajax({
                type: "post",
                url: "${base}/usecar/saveSelectedCar",
                dataType: "json",
                data : {"id":$("#id").val(),"carId":carId},
                success: function (data) {
                    if (data.flag) {
                        layer.msg(data.message, {icon: 1, time: 1000}, function () {
                            $("#id").val(data.empty.id);
                        });
                    } else {
                        layer.msg(data.message, {icon: 2, time: 2000});
                    }
                    var indexUrl = "${base}/usecar/index?processInsId="+$("#id").val();
                    parent.location.href=indexUrl;
                }
            });
        };

        //选中事件
        $("#select").click(function () {
            selected();
        });
        $(".menu-more").click(function(){
            var flag=$(this).attr("data-flag"),newsTop;
            if(flag=="up"){
                $(this).attr("data-flag","down");
                $(this).parents(".menu-group").children(".layui-form").css("height","30px");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","none");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("显示更多筛选条件");
                initHeight();
            }else{
                $(this).attr("data-flag","up");
                $(this).parents(".menu-group").children(".layui-form").css("height","auto");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","block");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("折叠更多筛选条件");
                initHeight();
            }

        });
        function initHeight(flag){
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+32+30;
            console.log(vheight);
            if(flag=="init"){
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
