<@com.html title="电话接听列表" import="viewList,list,screen" />
<body class="gtmap">
<#if type=="view">
    <@toolbar show=""/>
<#else>
    <@toolbar show="del"/>
</#if>
<div class="gtmap-body">
    <div class="gtmap-cnt">
        <div class="menu-group">
            <form class="layui-form gt-form-group gt-form-bdgroup">
                <div class="gt-new-form-item">
                    <div class="right-btnbox">
                        <div class="layui-btn layui-btn-sm" onclick="loadInfo()">
                            <i class="iconfont icon-sousuo"></i>搜索
                        </div>
                    </div>
                    <div class="left-form">
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    来电人：
                                </div>
                            </label>
                            <div class="layui-input-block ">
                                <input type="text" name="fromName" id="fromName" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    来电单位：
                                </div>
                            </label>
                            <div class="layui-input-block">
                                <input type="text" name="fromUnit" id="fromUnit" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    来电内容：
                                </div>
                            </label>
                            <div class="layui-input-block">
                                <input type="text" name="teleContent" id="teleContent" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                    </div>
                </div>

            </form>
            <div class="menu-more" data-flag="down">
                显示更多筛选条件
            </div>
        </div>
        <div class="tablebox">
        <#if type=="view">
            <div class="gt-table-header">
                <div class="gt-table-title">
                    电话接听列表
                </div>
            </div>
        </#if>
            <div id="table1">
            </div>
        </div>
    </div>
</div>




</body>

<script type="text/html" id="barDemo">
    <a class="layui-btn layui-btn-xs layui-btn-primary" lay-event="edit">编辑</a>
    <a class="layui-btn layui-btn-danger layui-btn-xs" lay-event="del">删除</a>
</script>
<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        var tableHeight=initHeight("init");
        //初始化查询
        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url:'${base}/telephone/findByPage',
                dataType: "json",
                where: {"fromName": $("#fromName").val(),"fromUnit": $("#fromUnit").val(),"teleContent": $("#teleContent").val()},
                height: 'full-'+tableHeight,
                defaultToolbar:[],
                id:'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    ,{field:'id', title:'id', width:'3%', fixed: 'left',hide: true}
                    ,{field:'fromName', title:'来电人姓名', width:'12.5%',templet:
                            function (d) {
                                var funStr ="goViewProject('" + d.id + "')";
                                return "<a style=\"color:#08c\" onclick=\"" + funStr + "\">"+d.fromName+"</a>"
                            }}
                    ,{field:'fromUnit', title:'来电单位', width:'12.5%'}
                    ,{field:'reciveName', title:'接电人姓名', width:'12.5%'}
                    ,{field:'teleContent', title:'来电内容', width:'22.5%'}
                    ,{field:'telephoneTime', title:'接电话时间', width:'10%',templet:"<div>{{layui.util.toDateString(d.telephoneTime*1000,'yyyy-MM-dd')}}</div>"}
                    ,{field:'remark', title:'备注', width:'27%'}
                ]],
                page: true
            });
        };

        window.goViewProject=function(id){
            window.open("${base}/telephone/index?view=true&processInsId="+id);
        };

        window.deleteAsset = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                var checkStatus = table.checkStatus('idTest')
                        ,data = checkStatus.data;
                for(var i=0;i<data.length;i++){
                    ids.push(data[i].id);
                }
                if (ids.length == 0) {
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/telephone/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.msg(data.message, {icon: 1, time: 2000});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        //点击事件（删除地块）
        $("#del").click(function (e) {
            deleteAsset();
        });

        //初始化查询
        loadInfo();
        $(".menu-more").click(function(){
            var flag=$(this).attr("data-flag"),newsTop;
            if(flag=="up"){
                $(this).attr("data-flag","down");
                $(this).parents(".menu-group").children(".layui-form").css("height","30px");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","none");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("显示更多筛选条件");
                initHeight();
            }else{
                $(this).attr("data-flag","up");
                $(this).parents(".menu-group").children(".layui-form").css("height","auto");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","block");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("折叠更多筛选条件");
                initHeight();
            }

        });
        function initHeight(flag){
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+32+30;
            console.log(vheight);
            if(flag=="init"){
                var bodyHeight=client().height-$(".gt-toolbar").height()-18;
                $(".gtmap-body").height(bodyHeight);
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
