<@com.html title="印刷申请列表" import="viewList,list,screen" />
<body class="gtmap">
<#if type=="view">
    <@toolbar show=""/>
<#else>
    <@toolbar show="del"/>
</#if>
<div class="gtmap-body">
    <div class="gtmap-cnt">
        <div class="menu-group">
            <form class="layui-form gt-form-group gt-form-bdgroup">
                <div class="gt-new-form-item">
                    <div class="right-btnbox">
                        <div class="layui-btn layui-btn-sm">
                            <div onclick="loadInfo()"><i class="iconfont icon-sousuo" ></i>搜索</div>
                        </div>
                    </div>
                    <div class="left-form">
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    申请人：
                                </div>
                            </label>
                            <div class="layui-input-block ">
                                <input type="text" name="applyPeople" id="applyPeople" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    申请部门：
                                </div>
                            </label>
                            <div class="layui-input-block">
                                <input type="text" name="applyUnit" id="applyUnit" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    申请类别：
                                </div>
                            </label>
                            <div class="layui-input-block">
                                <select name="applyType" id="applyType" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                    <option value=""></option>
                                    <option value="装订">装订</option>
                                    <option value="印刷">印刷</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="more-form">


            </form>
            <div class="menu-more" data-flag="down">
                显示更多筛选条件
            </div>
        </div>
        <div class="tablebox">
            <#if type=="view">
                <div class="gt-table-header">
                    <div class="gt-table-title">
                        印刷申请列表
                    </div>
                </div>
            </#if>
            <div id="table1">
            </div>
        </div>
    </div>
</div>




</body>

<script type="text/html" id="barDemo">
    <a class="layui-btn layui-btn-xs layui-btn-primary" lay-event="edit">编辑</a>
    <a class="layui-btn layui-btn-danger layui-btn-xs" lay-event="del">删除</a>
</script>
<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        var tableHeight=initHeight("init");
        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url:'${base}/print/findByPage',
                dataType: "json",
                where: {"applyPeople": $("#applyPeople").val(),"applyUnit": $("#applyUnit").val(),"applyType": $("#applyType").val()},
                height: 'full-'+tableHeight,
                defaultToolbar:[],
                id:'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    ,{field:'printId', title:'printId', width:'3%', fixed: 'left',hide: true}
                    ,{field:'applyPeople', title:'申请人姓名', width:'10%',templet:
                            function (d) {
                                var funStr ="goViewProject('" + d.printId + "')";
                                return "<a style=\"color:#08c\" onclick=\"" + funStr + "\">"+d.applyPeople+"</a>"
                            }}
                    ,{field:'applyUnit', title:'归属部门', width:'17%'}
                    ,{field:'applyType', title:'申请类别', width:'10%'}
                    ,{field:'applyTime', title:'申请时间', width:'10%',templet:"<div>{{layui.util.toDateString(d.applyTime*1000,'yyyy-MM-dd')}}</div>"}
                    ,{field:'printUse', title:'用途', width:'50%'}
                ]],
                page: true
            });
        };

        window.goViewProject=function(id){
            window.open("${base}/print/index?view=true&processInsId="+id);
        };

        window.deleteAsset = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                var checkStatus = table.checkStatus('idTest')
                        ,data = checkStatus.data;
                for(var i=0;i<data.length;i++){
                    ids.push(data[i].printId);
                }
                if (ids.length == 0) {
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/print/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.msg(data.message, {icon: 1, time: 2000});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        //点击事件（删除地块）
        $("#del").click(function (e) {
            deleteAsset();
        });

        //初始化查询
        loadInfo();
        $(".menu-more").click(function(){
            var flag=$(this).attr("data-flag"),newsTop;
            if(flag=="up"){
                $(this).attr("data-flag","down");
                $(this).parents(".menu-group").children(".layui-form").css("height","30px");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","none");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("显示更多筛选条件");
                initHeight();
            }else{
                $(this).attr("data-flag","up");
                $(this).parents(".menu-group").children(".layui-form").css("height","auto");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","block");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("折叠更多筛选条件");
                initHeight();
            }

        });
        function initHeight(flag){
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+32+30;
            console.log(vheight);
            if(flag=="init"){
                var bodyHeight=client().height-$(".gt-toolbar").height()-18;
                $(".gtmap-body").height(bodyHeight);
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
