<@com.html title="固定资产物品领用" import="layui,main"/>
<body class="gtmap blueStyle">
<style>
    .layui-table-cell {padding:0 !important;}
    .layui-table-cell input{border:0}
</style>
<div class="gt-container">
    <form class="layui-form" id="assetForm">
    <#if view=="">
        <@toolbar show="save,print" />
    <#else>

    </#if>
    <#-- 存储隐藏值-->
        <input type="hidden" name="id" value="${asset.id!}" id="id" >
        <input type="hidden" id="view" name="view" value="${view!}"/>
        <div class="gt-content">
            <div class="layui-tab layui-tab-brief">
                <h3 class="text-c">固定资产物品领用</h3>
                <h5 class="text-r">&nbsp;</h5>
                <table class="layui-table table-border">
                    <tr>
                        <td colspan="11" style="padding:2px 0 5px 15px;">
                            <button type="button" class="layui-btn layui-btn-sm" id="assetAdd">
                                <i class="layui-icon layui-icon-add-circle-fine"></i> 添 加
                            </button>
                            <button type="button" class="layui-btn layui-btn-sm layui-btn-danger" id="assetDel">
                                <i class="layui-icon layui-icon-delete"></i> 删 除
                            </button>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="width: 10%;">申请人</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input" type="text" id="applyPeople" name="applyPeople" placeholder="申请人" value="${asset.applyPeople!}">
                        </td>
                        <td class="text-c active" style="width: 10%;">申请部门</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input" type="text" id="applyUnit" name="applyUnit" placeholder="申请部门" value="${asset.applyUnit!}">
                        </td>
                        <td class="text-c active" style="width: 10%;">申请日期</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input layui-date"  type="text" id="applyTime" name="applyTime" placeholder="申请日期" value="${(asset.applyTime!.now)?string('yyyy-MM-dd')}">
                        </td>
                    </tr>
                    <tr class="active">
                        <th colspan="11" class="text-c bb-0">领用物品情况</th>
                    </tr>
                </table>
                <table class="layui-table table-border" lay-data="{ page: false, id: 'assetAttachmentList' }">
                    <thead>
                    <tr>
                        <th lay-data="{ type: 'checkbox',width: 47}"></th>
                        <th lay-data="{ field: 'attId', hide: true, templet: '#attIdTpl' }"></th>
                        <th lay-data="{ field: 'assetId', hide: true, templet: '#assetIdTpl' }"></th>
                        <th lay-data="{ field: 'assetType', width: 150, templet: '#assetTypeTpl' }">物品类别</th>
                        <th lay-data="{ field: 'assetName', width: 150, templet: '#assetNameTpl' }">物品名称</th>
                        <th lay-data="{ field: 'assetModel', width: 150, templet: '#assetModelTpl' }">物品型号</th>
                        <th lay-data="{ field: 'assetUnit', width: 150, templet: '#assetUnitTpl' }">单位</th>
                        <th lay-data="{ field: 'assetNum', width: 150, templet: '#assetNumTpl' }">数量</th>
                        <th lay-data="{ field: 'assetPrice', width: 150, templet: '#assetPriceTpl' }">价格/元</th>
                    </tr>
                    </thead>
                </table>
                <table class="layui-table table-border">
                    <tr class="active">
                        <td colspan="11" class="active" style="padding-left:10px">物品用途及理由：</td>
                    </tr>
                    <tr>
                        <td colspan="12" class="pd0" style="height: 68px">
                            <textarea class="layui-textarea" id='reason' name='reason' lay-verify="content" placeholder="说点什么">${asset.reason!}</textarea>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </form>
</div>
<script type="text/html" id="attIdTpl">
    <input type="text" class="layui-input" field="attId" name="assetAttachmentList[{{d.LAY_INDEX-1}}].attId" value="{{d.attId||''}}"/>
</script>
<script type="text/html" id="assetIdTpl">
    <input type="text" class="layui-input" field="assetId" name="assetAttachmentList[{{d.LAY_INDEX-1}}].assetId" value="{{d.assetId||''}}"/>
</script>
<script type="text/html" id="assetTypeTpl">
    <select field="assetType" name="assetAttachmentList[{{d.LAY_INDEX-1}}].assetType" id="assetAttachmentList[{{d.LAY_INDEX-1}}].assetType" onchange="goSelect('{{d.LAY_INDEX-1}}')" class="layui-form-select"  lay-ignore>
    <#list wpType as wpType>
        <option value="${wpType.name!}" {{# if(d.assetType == '${wpType.name!}'){ }}selected{{# } }}>${wpType.name!}</option>
    </#list>
    </select>
</script>
<script type="text/html" id="assetNameTpl">
    <select field="assetName" name="assetAttachmentList[{{d.LAY_INDEX-1}}].assetName" class="layui-form-select" lay-ignore>
    <#list sbmc as sbmc>
        <option value="${sbmc.name!}" {{# if(d.assetName == '${sbmc.name!}'){ }}selected{{# } }}>${sbmc.name!}</option>
    </#list>
    </select>
</script>
<script type="text/html" id="assetModelTpl">
    <input type="text" class="layui-input text-c" field="assetModel" name="assetAttachmentList[{{d.LAY_INDEX-1}}].assetModel" value="{{d.assetModel||''}}"/>
</script>
<script type="text/html" id="assetUnitTpl">
    <input type="text" class="layui-input text-c" field="assetUnit" name="assetAttachmentList[{{d.LAY_INDEX-1}}].assetUnit" value="{{d.assetUnit||''}}"/>
</script>
<script type="text/html" id="assetNumTpl">
    <input type="text" class="layui-input text-c" field="assetNum" name="assetAttachmentList[{{d.LAY_INDEX-1}}].assetNum" onkeyup="this.value=this.value.replace(/[^\d]/g,'') " value="{{d.assetNum||''}}" />
</script>
<script type="text/html" id="assetPriceTpl">
    <input type="text" class="layui-input text-c" field="assetPrice" name="assetAttachmentList[{{d.LAY_INDEX-1}}].assetPrice" onkeyup="this.value=this.value.replace(/[^\d]/g,'') " value="{{d.assetPrice||''}}" />
</script>
<script type="text/javascript">
    layui.use(['form','laydate','table'], function(){
        //初始化模块
        var form = layui.form, $ = layui.$,layer = layui.layer,laydate = layui.laydate,table=layui.table;

        // 初始化领用物品情况
        function initAsset() {
            $.ajax({
                type: 'get',
                url: "${base}/asset/assetList",
                data: {proid: '${proid}'},
                success: function(data) {
                    if (data) {
                        table.reload('assetAttachmentList',{data: data, limit: data.length});
                        for (var i=0;i<data.length;i++) {
                            goSelect(i);
                        }
                    }
                }
            });
        }
        initAsset();

        window.goSelect=function(id){
                var assetType = 'assetAttachmentList['+id+'].assetType';
                var assetName = 'assetAttachmentList['+id+'].assetName';
                $("[name='"+assetName+"']").find("option").remove();
                var url = "getDictByType";
                var params = {
                    "dictId": $("[name='"+assetType+"']").val()
                };
                $.post(url, params, function(data) {
                    mychange(data,assetName);
                },"json");
            };

        $(function(){
            var view = $("#view").val();
            if(view!=""){
                $(".gt-container").css('top',"16px");
            }else {
            }
        });

        function mychange(val,assetName){
            var jsonObject = eval(val);
            for(var index = 0; index < jsonObject.length; index++){
                var opt = "<option value=\"" + jsonObject[index].name + "\">" + jsonObject[index].name + "</option>"
                $("[name='"+assetName+"']").append(opt);
            }
            var codevalue = "${asset.assetType!}";
//            if(codevalue!=null || codevalue!=" "){
//                setTimeout(function() {
//                    $("[name='assetType']").val(codevalue);
//                }, 1);
//            }
        }

        // 添加情况
        $("#assetAdd").click(function() {
            var data = getLayuiTableData('assetAttachmentList');
            //var data = table.cache['sqgdqk'];
            var tmp = {"attId":"","assetId":"${proid!}","assetType":"","assetName":"","assetModel":"","assetUnit":"","assetNum":"","assetPrice":""};
            data.push(tmp);
            table.reload('assetAttachmentList',{data: data, limit: data.length});
            for (var i=0;i<data.length;i++) {
                goSelect(i);
            }
        });

        //删除情况
        $("#assetDel").click(function() {
            var data = table.checkStatus('assetAttachmentList').data;
            if (data.length == 0) {
                // layer.msg("请选择需要删除的数据！",{icon:2,time:2000});
                layer.msg('请勾选要删除的数据', function(){
                    //关闭后的操作
                });
                return;
            }
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function () {
                var ids = [];
                $.each(data, function(idx, val) {
                    ids.push(val.attId);
                });
                $.ajax({
                    url: '${base}/asset/deleteAtt',
                    type: 'post',
                    data: {ids: ids.join(",")},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.3
                        })
                    },
                    complete: function () {
                    },
                    success : function (data) {
                        if (data.flag) {
                            // layer.msg(data.message, {icon: 1, time: 2000});
                            layer.alert(data.message, {icon: 6});
                            // 刷新数据
                            initAsset();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        });

        laydate.render({
            elem: '#applyTime' //指定元素
            //type:'datetime'
            //range: true
        });

        //监听提交
        form.on('submit(formSave)', function(data) {
            /**
             * 表单提交
             */
                var form = $('.layui-form');
                $.ajax({
                    type: "post",
                    url: "${base}/asset/save",
                    //contentType: "application/json;charset=UTF-8",
                    //dataType: "json",
                    data:form.serialize(),// JSON.stringify(form.serializeArray())
                    beforeSend: function () {
                        layer.msg('正在保存...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    success: function (data) {
                        layer.alert(data.msg, {icon: 6});
                        initAsset();
                    }
                });
            return false;
        });




    });

</script>
</body>