<@com.html title="日程管理" import="layui,schedule,xadmin,util,main,screen"/>
<style>
    #schedule {
        width: 1000px;
        margin: 20px auto;
    }
    body {
        background: white!important;
        overflow-y: hidden;
    }

    body, th, td, button, input, select, textarea {
        font-family: "Microsoft Yahei", "Hiragino Sans GB", "Helvetica Neue", Helvetica, tahoma, arial, "WenQuanYi Micro Hei", Verdana, sans-serif, "\5B8B\4F53";
        font-size: 15px;
        color: #333;
        -webkit-font-smoothing: antialiased;
    }
</style>
<body class="gtmap blueStyle">
    <div id='schedule'></div>
        <div id="legend" class="row cl center" style="width: 1000px; margin: auto">
            <div class="col-sm-2" style="margin-top: 5px; width: 16.67%;">
                <div class="col-sm-8" style="width: 60%;">本人创建日程：</div>
                <div class="col-sm-4" style="background-color: #1883ff; width: 40%;"> &nbsp;&nbsp;&nbsp;</div>
            </div>
            <div class="col-sm-2" style="margin-top: 5px; width: 16.67%;">
                <div class="col-sm-8" style="text-align: right; width: 60%;">&nbsp;参与日程：</div>
                <div class="col-sm-4" style="background-color: green; width: 40%;"> &nbsp;&nbsp;&nbsp;</div>
            </div>
            <div class="col-sm-2" style="margin-top: 5px; width: 16.67%;">
                <div class="col-sm-8" style="text-align: right; width: 60%;">公开日程：</div>
                <div class="col-sm-4" style="background-color: #e5e5e5; width: 40%;"> &nbsp;&nbsp;&nbsp;</div>
            </div>
        </div>
<script type="text/javascript">
    layui.use(['form','laydate','element'],function() {
        //初始化模块
        var $ = layui.$;
        var layer = layui.layer;
    });
    var scheduleUrl = "${base}/schedule";
    var userId = "${userId}";
    var userName = "${userName}";
    var acceptDataIdList = [];

    $(document).ready(function () {
        var date = new Date();
        var d = date.getDate();
        var m = date.getMonth();
        var y = date.getFullYear();

        $('#schedule').fullCalendar({
            theme: false,
            header: {
                left: 'prev,next today',
                center: 'title',
                right: 'month,basicWeek'
            },
            aspectRatio: 2.0,
            //weekMode: 'variable',
            allDaySlot:false,
            firstHour: 6,
            slotMinutes: 30,
            defaultEventMinutes: 120,
            axisFormat: 'HH(:mm):00',
            dragOpacity: {
                agenda: .5
            },

            minTime: 8,
            maxTime: 20,
            weekends:true,
            allDayDefault:false,
            //defaultView: "${viewName!'month'}",
            defaultDate: new Date('<#if curentDate??>${curentDate} 00:00:00<#else>${.now}</#if>'.replace('-', '/')),
            monthNames: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
            monthNamesShort: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
            dayNames: ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
            dayNamesShort: ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
            today: ["今天"],
            firstDay: 1,
            buttonText: {
                today: '今天',
                month: '月',
                week: '周',
                day: '日',
                prev: ' ◄ ',
                next: ' ► '
            },
            viewDisplay: function (view) {//动态把数据查出，按照月份动态查询
                var viewStart = $.fullCalendar.formatDate(view.start, "yyyy-MM-dd HH:mm:ss");
                var viewEnd = $.fullCalendar.formatDate(view.end, "yyyy-MM-dd HH:mm:ss");
                $("#schedule").fullCalendar('removeEvents');

                acceptDataIdList = [];
                var url = scheduleUrl + "/getScheduleList";
                var colorType = "";

                // 加载自己创建的日程
                colorType = "canEdit";
                var param = {};
                param["appointerId"] = userId;
                renderScheduleData(url, viewStart, viewEnd, param, colorType);

                // 加载自己参与的日程
                colorType = "partake";
                var param = {};
                param["participantId"] = userName;
                renderScheduleData(url, viewStart, viewEnd, param, colorType);

                // 加载别人公开的日程
                colorType = "public";
                var param = {};
                param["isPublic"] = "1";
                renderScheduleData(url, viewStart, viewEnd, param, colorType);

                // 更新url，刷新页面时，显示当前位置
                refreshUrlParam("curentDate", $('#schedule').fullCalendar('getDate').Format('yyyy-MM-dd'));
                refreshUrlParam("viewName", $('#schedule').fullCalendar('getView').name);

                changeButtonText();
            },
            editable: false,//判断该日程能否拖动
            dayClick: function (date, allDay, jsEvent, view) {//日期点击后弹出的jq ui的框，添加日程记录
                var defaultBeginDate = new Date();
                if ('month' == view.name) {
                    defaultBeginDate.setYear(date.getFullYear());
                    defaultBeginDate.setMonth(date.getMonth(), date.getDate());
                } else if ('agendaWeek' == view.name) {
                    defaultBeginDate = date;
                } else if ('basicWeek' == view.name) {
                    defaultBeginDate = date;
                }
                var defaultEndDate = new Date(+defaultBeginDate);
                defaultEndDate.setDate(defaultBeginDate.getDate() + 2 / 24);
                var addUrl =  scheduleUrl + "/edit?defaultBeginDate=" + defaultBeginDate.Format("yyyy-MM-dd HH:mm:ss") + "&defaultEndDate=" + defaultEndDate.Format("yyyy-MM-dd HH:mm:ss");
                x_admin_show("新增日程",addUrl,"700","370");
                return false;
            },
            titleFormat: {
                month: 'yyyy年 MMMM',
                week: "[yyyy年] MMMMd日 { '&#8212;' [yyyy年] MMMMd日}",
                day: 'yyyy年 MMMMd日 dddd'
            },
            timeFormat: "HH:mm",
            loading: function (bool) {
                if (bool) $('#loading').show();
                else $('#loading').hide();
            },
            eventAfterRender: function (event, element, view) {//数据绑定上去后添加相应信息在页面上
                var fstart = $.fullCalendar.formatDate(event.start, "HH:mm");
                var fend = $.fullCalendar.formatDate(event.end, "HH:mm");
                var title = event.title;
                var confbg = '';
                confbg = confbg + '<td class="fc-event-bg"></td>';

                var statements = [];
                if (event.color) {
                    statements.push('background-color:' + event.color);
                    statements.push('border-color:' + event.color);
                }
                var skinCss = statements.join(';');

                var beginDate = $.fullCalendar.formatDate(event.start, "yyyy/MM/dd");
                var endDate = $.fullCalendar.formatDate(event.end, "yyyy/MM/dd");

                var participantId = event.participantId;
                var participantIds=participantId.split(",");
                var len = 2;
                var length = participantIds.length;
                var cyrs = "";
                if(length>len){
                    len = length;
                }
                if(len>2){
                    len = 2;
                    var cyr = new Array();
                    for(var i=0;i<len;i++){
                        cyr.push(participantIds[i]);
                    }
                    cyrs = cyr.join(",");
                    cyrs = cyrs+"等";
                }else {
                    var cyr = new Array();
                    for (var i = 0; i < len; i++) {
                        cyr.push(participantIds[i]);
                    }
                    cyrs = cyr.join("");
                }

                var nr = event.content;

                var evtcontent = '<div class="fc-event-inner fc-event-skin"' + (skinCss ? ' style="' + skinCss + '"' : '') + '>';

                evtcontent = evtcontent + confbg;
                //evtcontent = evtcontent + '<td class="fc-event-title">标  题:'+event.title +'<br>'+'参与人:'+cyrs +'<br>'+'时  间:' + '</td>';
                evtcontent = evtcontent + "<td class='fc-event-title'>"+ fstart + " - " + fend +"&nbsp;"+ event.title + "</td>";
                evtcontent = evtcontent + "</div>";

                element.html(evtcontent);

                var fstart = $.fullCalendar.formatDate(event.start, "yyyy/MM/dd HH:mm");
                var fend = $.fullCalendar.formatDate(event.end, "yyyy/MM/dd HH:mm");
                $(element).attr('title', "参与人："+participantId +"   内容：" + nr +"   时间：" + fstart + " - " + fend );
            },
            eventMouseover: function (calEvent, jsEvent, view) {

            },
            eventClick: function (event) {
                var url = scheduleUrl + "/edit?id=" + event.id;
                if (event.readOnly) {
                    url += "&acceptView=true";
                } else {
                    url += "&canDelete=true";
                }
                x_admin_show("编辑日程",url,"700","430");

                return false;
            },
            events: []
        });

        try {
            if ($.browser.msie) {
                $("#schedule .fc-header-right table td:eq(0)").before('<td><div class="ui-state-default ui-corner-left ui-corner-right" style="border-right:0px;padding:1px 3px 2px;" ><input type="text" id="selecteddate" size="10" style="padding:0px;"></div></td><td><div class="ui-state-default ui-corner-left ui-corner-right"><a><span id="selectdate" class="ui-icon ui-icon-search">goto</span></a></div></td><td><span class="fc-header-space"></span></td>');
            } else {
                $("#schedule .fc-header-right table td:eq(0)").before('<td><div class="ui-state-default ui-corner-left ui-corner-right" style="border-right:0px;padding:3px 2px 4px;" ><input type="text" id="selecteddate" size="10" style="padding:0px;"></div></td><td><div class="ui-state-default ui-corner-left ui-corner-right"><a><span id="selectdate" class="ui-icon ui-icon-search">goto</span></a></div></td><td><span class="fc-header-space"></span></td>');
            }
        } catch (ex) {

        }

        $("#selecteddate").datepicker({
            dateFormat: 'yy-mm-dd',
            beforeShow: function (input, instant) {
                setTimeout(
                        function () {
                            $('#ui-datepicker-div').css("z-index", 15);
                        }, 100
                );
            }
        });

        $("#selectdate").click(function () {
            var selectdstr = $("#selecteddate").val();
            var selectdate = $.fullCalendar.parseDate(selectdstr, "yyyy-mm-dd");
            $('#schedule').fullCalendar('gotoDate', selectdate.getFullYear(), selectdate.getMonth(), selectdate.getDate());
        });

        $("#schedule .fc-header-left table td:eq(0)").before('<td><div class="ui-state-default ui-corner-left ui-corner-right" id="selectmeeting"><a><span id="selectdate" class="ui-icon ui-icon-search" style="float: left;padding-left: 5px; padding-top:1px"></span>meeting room</a></div></td><td><span class="fc-header-space"></span></td>');
    });


    function refreshUrlParam(name, value) {
        var index = window.location.href.indexOf("?");

        var vars = {};
        vars[name] = value;
        var url = window.location.href;
        if (index >= 0) {
            url = window.location.href.substr(0, index);

            var hash;
            var hashes = window.location.href.slice(index + 1).split('&');
            for (var i = 0; i < hashes.length; i++) {
                hash = hashes[i].split('=');
                if (hash[0] != name) {
                    vars[hash[0]] = hash[1];
                }
            }
        }

        var varStr = "";
        for (var p in vars) { // 方法
            varStr += "&" + p + "=" + vars[p];
        }

        url = "schedulePage";
        url += (varStr == "" ? "" : "?" + varStr.slice(1));
        History.pushState({}, "日程管理", url);
    }

    // 加载日程数据
    function renderScheduleData(url, viewStart, viewEnd, paramObj, colorType) {
        setTimeout(function () {
            $.ajax({
                async: false,
                type: 'post',
                url: url,
                data: {
                    beginTime: viewStart,
                    endTime: viewEnd,
                    colorType: colorType,
                    paramStr: JSON.stringify(paramObj)
                },
                dataType: 'json',
                success: function (data) {
                    var resultCollection = data.scheduleList;
                    $.each(resultCollection, function (index, term) {
                        if ($.inArray(term.id, acceptDataIdList) > -1) {
                            return;
                        } else {
                            acceptDataIdList.push(term.id);
                        }
                        renderScheduleTerm(term, colorType, data.colorValue, viewStart, viewEnd);

                    });
                }
            });
        }, 10);
    }

    // 将日程数据转换成渲染的对象
    function renderScheduleTerm(term, colorType, color, viewStart, viewEnd) {
        var obj = new Object();
        obj.id = term.id;
        obj.title = term.caption;
        obj.start = new Date(term.beginTime.replace('-', '/'));
//        obj.endTime = new Date(term.endTime.replace('-', '/'));
        obj.end = new Date(term.endTime.replace('-', '/'));
        obj.backgroundColor = color;
        obj.content = term.content;
        obj.allDay = false;
        obj.color = color;
        obj.participantId = term.participantId;
        var time = new Date(term.beginTime.replace('-', '/'));
        var newTime = new Date();
        obj.readOnly = newTime>time && userId != "4028882a644a8bc601644a8c6d930001" && term.appointerId != userId ;//  new Date(term.beginTime.replace('-', '/')) > new Date() ;//&& term.isPublished == '1'

        // 检查是否循环
        var viewStartDate = new Date(viewStart.replace('-', '/'));
        var viewEndDate = new Date(viewEnd.replace('-', '/'));
        var termStartDate = new Date(term.beginTime.replace('-', '/'));
        var termEndDate = new Date(term.endTime.replace('-', '/'));

        if ("每周" == term.circleType) {
            if (obj.start < viewStartDate) {
                var addDay = (termStartDate.getDay() - viewStartDate.getDay() + 7) % 7;
                termStartDate.setYear(viewStartDate.getFullYear());
                termStartDate.setMonth(viewStartDate.getMonth(), viewStartDate.getDate());
                termStartDate.setDate(termStartDate.getDate() + addDay);

                termEndDate = new Date(termStartDate.Format('yyyy/MM/dd hh:mm:ss'));
                termEndDate.setDate(termEndDate.getDate() + Math.abs(obj.end - obj.start) / 1000 / 60 / 60 / 24);
                obj.start = new Date(termStartDate.Format('yyyy/MM/dd hh:mm:ss'));
                obj.end = new Date(termEndDate.Format('yyyy/MM/dd hh:mm:ss'));
            }

            while (obj.start < viewEndDate) {
                $("#schedule").fullCalendar('renderEvent', obj, true);

                var objTemp = obj;
                var obj = new Object();
                obj.id = objTemp.id;
                obj.title = objTemp.title;
                obj.start = new Date(objTemp.start.Format('yyyy/MM/dd hh:mm:ss'));
                obj.end = new Date(objTemp.end.Format('yyyy/MM/dd hh:mm:ss'));
//                obj.endTime = new Date(objTemp.endTime.Format('yyyy/MM/dd hh:mm:ss'));
                obj.backgroundColor = objTemp.backgroundColor;
                obj.content = objTemp.content;
                obj.allDay = objTemp.allDay;
                obj.color = objTemp.color;
                obj.readOnly = objTemp.readOnly;

                obj.start.setDate(obj.start.getDate() + 7);
                obj.end.setDate(obj.end.getDate() + 7);
            }
        } else if ("每月" == term.circleType) {
            if (obj.start < viewStartDate) {
                termStartDate.setYear(viewStartDate.getFullYear());
                termStartDate.setMonth(viewStartDate.getMonth(), termStartDate.getDate());

                termEndDate.setDate(termEndDate.getDate() + Math.abs(obj.end - obj.start) / 1000 / 60 / 60 / 24);
                obj.start = termStartDate;
                obj.end = termEndDate;
            }

            $("#schedule").fullCalendar('renderEvent', obj, true);
        } else {
            $("#schedule").fullCalendar('renderEvent', obj, true);
        }
    }

    /**
     * 改变pre、next、today的显示名称
     */
    function changeButtonText() {
        var viewName = $('#schedule').fullCalendar('getView').name;
        if ("month" == viewName) {
            $(".fc-button-prev .fc-button-content").text("上一月");
            $(".fc-button-next .fc-button-content").text("下一月");
            $(".fc-button-today .fc-button-content").text("本月");
        } else if ("agendaWeek" == viewName) {
            $(".fc-button-prev .fc-button-content").text("上一周");
            $(".fc-button-next .fc-button-content").text("下一周");
            $(".fc-button-today .fc-button-content").text("本周");
        } else if ("basicWeek" == viewName) {
            $(".fc-button-prev .fc-button-content").text("上一周");
            $(".fc-button-next .fc-button-content").text("下一周");
            $(".fc-button-today .fc-button-content").text("本周");
        }
    }

</script>
</body>
