//业务通用js
layui.use(['jquery'], function() {
    var $ = layui.$;

    //全选
    $(document).ready(function () {
        //checkbox的全选
        $("#allCheckbox").click(function () {
            $("[name=checkbox]:checkbox").each(function (i, e) {
                if($("#allCheckbox").prop("checked")) {
                    $(e).prop("checked", true);
                } else {
                    $(e).prop("checked", false);
                }
            });
        });
    });

//将form数据转换成json对象
    window.getFormJson = function(form) {
        var o = {};
        var a = $("#"+form).serializeArray();
        $.each(a, function () {
            if (o[this.name] !== undefined) {
                if (!o[this.name].push) {
                    o[this.name] = [o[this.name]];
                }
                o[this.name].push(this.value || '');
            } else {
                o[this.name] = this.value || '';
            }
        });
        return o;
    }

    var otherHeight = 73;
    $(function() {
        gtInit();

        $(window).resize(function() {
            gtInit();
        });
    });

    function gtInit() {
        $(".gt-content,.gt-min-h").css("min-height", $(window).height() - otherHeight);

        $(".gt-head").removeAttr("style");
        if ($(".gt-head").width() > $(window).width()) {
            $(".gt-head").width($(window).width() - 50);
        }

    }

    /**
     * 用于layui table插入行
     * @param layId
     * @returns {Array}
     */
    window.getLayuiTableData=function(layId) {
        var data = [];
        $.each($("div[lay-id='" + layId + "'] .layui-table-body tr"), function() {
            var field = {};
            $.each($(this).find("*[field]"), function() {
                field[$(this).attr("field")] = $(this).val();
            });
            data.push(field);
        });
        return data;
    };

    /**
     * 弹出新页面（使用之前需要引用layer）
     */
     window.layerOpen=function(url, width, height, title,resize,layId){
        if(!width){
            width = $(window).width() * 0.9;
        }
        if(!height){
            height = $(window).height() * 0.9;
        }
        if(!title){
            title = '　';
        }
        var left = ($(window).width()-width)/2;
        var top = ($(window).height()-height)/2;
        layui.use('layer', function(){
            var layer = layui.layer;

            layer.open({
                id:"layer_"+layId+"",
                type: 2,
                title: title,
                fix: false,
                offset: [top+'px',left + 'px'],
                shadeClose: false,
                resize: resize?resize:false,
                maxmin: resize?resize:false,//true,
                area: [width + 'px', height + 'px'],
                content: url
            });
        });

    };
    /**
     *生成uuid
     * @param len 长度
     * @param radix 基数
     *uuid(8, 16)
     **/
    window.UUID=function (len, radix) {
            var chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'.split('');
            var uuid = [], i;
            radix = radix || chars.length;
            if (len) {
                for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random()*radix];
            } else {
                var r;
                uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
                uuid[14] = '4';
                for (i = 0; i < 36; i++) {
                    if (!uuid[i]) {
                        r = 0 | Math.random()*16;
                        uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
                    }
                }
            }
            return uuid.join('');
        }
});
