//树设置
var setting = {
    view: {
        dblClickExpand: false
    },
    data: {
        simpleData: {
            enable: true,
            idKey: "typeId",   //节点数据中保存唯一标识的属性名称
            pIdKey: "ftypeParentId",    //节点数据中保存其父节点唯一标识的属性名称
            rootPId: -1  //用于修正根节点父节点数据，即 pIdKey 指定的属性值
        },
        key: {
            name: "fname"  //zTree 节点数据保存节点名称的属性名称  默认值："name"
        }
    },
    callback: {
        onClick: zTreeOnClick,
        onRightClick: OnRightClick

    }
};
$(function(){
    initZTree();
    hideRMenu();
    $("#pNode").hide();
    $("#formEdit").hide();
    //新增
    $("#m_add").on("click",function(){
        editTreeNode();
    });
    //修改
    $("#m_rename").on("click",function(){
        updateTreeNode();
    });
    //删除
    $("#m_del").on("click",function(){
        removeTreeNode();
    });
});
//设置按标签颜色
function aCss() {
    $(".li_List_Style li:last-child").css({"background-color": "#f5f5f5", "color": "#fff!important"});
    $(".li_List_Style li:last-child").find("a").css("color", "#000!important");
}
//初始化树
var treeObj, rMenu,ztreeNode;
var rMenu;
function initZTree() {
    $.ajax({
        type:"POST",
        url:"getLawsTypeList",
        async:true,
        success:function(lawsTypeList){
            $.fn.zTree.init($("#lawsType"), setting, lawsTypeList); //初始化树
            rMenu=$("#rMenu");
            treeObj = $.fn.zTree.getZTreeObj("lawsType");
            var nodes = treeObj.getNodes();
            //if (nodes.length > 0) {
            //    treeObj.expandNode(nodes[0], true, false, false);//默认展开第一个父节点
            //}
            $("#formEdit").click(saveMenuNode);
            treeObj.expandAll(true);   //true 节点全部展开、false节点收缩
        }
    });
}
/**
 * 初始化属性值
 */

var strAn = '<span class="button add" id="addBtn_dictTree_2" title="添加" onfocus="this.blur();"></span>' +
    '<span class="button edit" id="dictTree_2_edit" title="修改" treenode_edit="" style=""></span>' +
    '<span class="button remove" id="dictTree_2_remove" title="删除" treenode_remove="" style=""></span>';
/**
 *  目次属性赋值
 */
function dictFz(ztreeNode) {
    $("#formEdit").hide();
    //获取其父节点
    if (ztreeNode.ftypeParentId == -1) {
        //如果为根节点隐藏父节点名称展示行
        $("#pNode").hide();
        $("#ftypeParentName").val("");
        $("#ftypeParentName").attr("readonly","readonly");
    }else{
        var pnode = ztreeNode.getParentNode();
        //给父节点名称文本框赋值并设置为只读模式
        $("#pNode").show();
        $("#ftypeParentName").val(pnode.fname);
        $("#ftypeParentName").attr("readonly","readonly");
    }
    $("input[name='fname']").val(ztreeNode.fname);
    $("#fname").attr("readonly","readonly");
    $("input[name='fmemo']").val(ztreeNode.fmemo);
    $("#fmemo").attr("readonly","readonly");
    if(ztreeNode.isUse!=null && ztreeNode.isUse =="否" ){
        $("#no").attr("checked",true);
        layui.form.render('radio');
    }else if(ztreeNode.isUse!=null && ztreeNode.isUse =="是"){
        $("#is").attr("checked",true);
        layui.form.render('radio');
    }
}
/**
 * 单击赋值属性值
 * @param event
 * @param treeId
 * @param treeNode
 */
function zTreeOnClick(event, treeId, treeNode) {
    dictFz(treeNode);
}

/**
 * 右击事件
 * @param event
 * @param treeId
 * @param treeNode
 * @constructor
 */
function OnRightClick(event, treeId, treeNode) {
    if (treeNode) {
        ztreeNode = treeNode;
    }
    if (!treeNode && event.target.tagName.toLowerCase() != "button" && $(event.target).parents("a").length == 0) {
        treeObj.cancelSelectedNode();
        showRMenu("root", event.clientX, event.clientY);
    } else if (treeNode && !treeNode.noR) {
        treeObj.selectNode(treeNode);
        showRMenu("node", event.clientX+30, event.clientY);
    }
}

function showRMenu(type, x, y) {
    $("#rMenu ul").show();
    if (type=="root") {
        $("#m_del").hide();
        $("#m_check").hide();
        $("#m_unCheck").hide();
    } else {
        $("#m_del").show();
        $("#m_check").show();
        $("#m_unCheck").show();
    }
    rMenu.css({"top":y+"px", "left":x+"px", "visibility":"visible"});

    $("body").bind("mousedown", onBodyMouseDown);
}

function hideRMenu() {
    if (rMenu) rMenu.css({"visibility": "hidden"});
    $("body").unbind("mousedown", onBodyMouseDown);
}
function onBodyMouseDown(event){
    if (!(event.target.id == "rMenu" || $(event.target).parents("#rMenu").length>0)) {
        rMenu.css({"visibility" : "hidden"});
    }
}
var addCount = 1;
function catalogAdd(){
    hideRMenu();
    $("#shuxing").show();
    $("#formEdit").show();
    $("#fname").val('');
    $("#pNode").hide();
}
function editTreeNode() {
    hideRMenu();
    $("#shuxing").show();
    $("#pNode").show();
    $("#formEdit").show();
    $("#ftypeParentName").val(ztreeNode.fname);
    $("#ftypeParentName").attr("readonly","readonly");
    $("#fname").val('');
    $("#fmemo").val('');
    $("#fname").removeAttr("readonly");
    $("#fmemo").removeAttr("readonly");
    event.stopPropagation();
}

//修改
function updateTreeNode() {
    //展示修改的Div
    $("#shuxing").show();
    //展示修改保存按钮
    $("#formEdit").show();
    //判断是否为根节点
    if (ztreeNode.ftypeParentId == -1) {
        //如果为根节点隐藏父节点名称展示行
        $("#pNode").hide();
    } else {
        //获取其父节点
        var pnode = ztreeNode.getParentNode();
        //展示其父节名称框
        $("#pNode").show();
        //给父节点名称文本框赋值并设置为只读模式
        $("#ftypeParentName").val(pnode.fname);
        $("#ftypeParentName").attr("readonly","readonly");
    }
    //为节点名称框赋值
    $("#fname").val(ztreeNode.fname);
    $("#fname").removeAttr("readonly");
    //为节点备注框赋值
    $("#fmemo").val(ztreeNode.fmemo);
    $("#fmemo").removeAttr("readonly");
    //设置隐藏域节点id
    $("#typeId").val(ztreeNode.typeId);
}
function removeTreeNode() {
    hideRMenu();
    var isDelete = true;
    layer.confirm('注意!</br>对应子节点也将被删除,您确定要删除吗？', {icon: 3, fname: '提示', btn: ['确定', '取消']},
        function () {//确定事件
            $.ajax({
                async: true,
                url: "delete",
                type: "post",
                data: {
                    typeId: ztreeNode.typeId,
                    ftypeParentId: ztreeNode.ftypeParentId,
                    sort: ztreeNode.sort
                },
                dataType: "json",
                success: function (result) {
                    debugger;
                    if (result == "success") {
                        layer.msg('删除成功!', {icon: 1, time: 2000},function(){window.location.reload();});
                        var index = parent.layer.getFrameIndex(window.name);
                        layer.close(index);
                    } else {
                        window.layer.msg('删除失败!', {icon: 2, time: 2000});
                    }
                }
            });
        }, function () {//取消事件
            window.location.reload();
        })
    return isDelete;
}
function saveMenuNode(){
    var form = $('#formId');
    var ftypeParentId;
    if(ztreeNode== undefined){
        ftypeParentId="";
    }else {
        ftypeParentId = ztreeNode.typeId;
    }
    $.ajax({
        async: false,
        url: 'save',
        type: "post",
        data: form.serialize()+"&ftypeParentId="+ftypeParentId,
        dataType: "json",
        success: function (data) {
            if (data == "success") {
                window.location.reload();
                //var index = parent.layer.getFrameIndex(window.name);
                //parent.layer.close(index);

            }
            else if (data.result == "false") {
                layer.msg('添加失败!', {icon: 2, time: 2000});
            }
        },
        complete: function () {
            window.location.reload();
            var index = parent.layer.getFrameIndex(window.name);
            parent.layer.close(index);
        }
    });
}
function hideRMenu() {
    if (rMenu) rMenu.css({"visibility": "hidden"});
    $("body").unbind("mousedown", onBodyMouseDown);
}
















