package com.gtis.oa.util;

import com.gtis.config.AppConfig;
import com.gtis.oa.model.Dispatch;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.oa.util.SessionUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

import javax.annotation.Resource;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Component
public class MacroUtil {
    /** 日志记录 */
    protected static final Logger logger = LoggerFactory.getLogger(MacroUtil.class);
    /** 模板管理工厂 */
    private static Configuration freeMarkerConfigurer;

    private static Map<String,HashMap<String,String>> templateView;

    private MacroUtil() {
    }
    @Autowired
    public void setFreeMarkerConfigurer(Configuration freeMarkerConfigurer) {
        MacroUtil.freeMarkerConfigurer = freeMarkerConfigurer;
    }
//    @Resource(name="templateView")
//    public void setMap(Map<String, HashMap<String, String>> templateView) {
//        this.templateView = templateView;
//    }

    /**
     * 获得套红模板
     * @param templateName
     * @return
     */
    public static Template getTextTemplate(String templateName) throws IOException {
        return freeMarkerConfigurer.getTemplate("document/wordOcx/套红模板/"+templateName + ".ftl");
    }

    /**
     * 发文Map转换
     * @param dispatch
     * @return
     */
    public static Map<String,String> dispatchToMap(Dispatch dispatch,String basePath){
        Map<String, String> map = new HashMap<String, String>();

        if(dispatch.getDispatchId() != null){
            map.put("dispatchId",dispatch.getDispatchId());
        }else {
            map.put("dispatchId","");
        }
        if(dispatch.getDispatchTitle() != null){
            map.put("dispatchTitle",dispatch.getDispatchTitle());
        }else{
            map.put("dispatchTitle","");
        }
        if(dispatch.getCopySend() != null){
            map.put("copySend",dispatch.getCopySend());
        }
        if(dispatch.getDispatchName() != null){
            map.put("dispatchName",dispatch.getDispatchName());
        }else {
            map.put("dispatchName","");
        }
        if(dispatch.getDispatchYear() != null){
            map.put("dispatchYear",dispatch.getDispatchYear());
        }else {
            map.put("dispatchYear","");
        }
        if(true){
            String dispatchNo = String.valueOf(dispatch.getDispatchNo());
            map.put("dispatchNo",dispatchNo);
        }else {
            map.put("dispatchNo","");
        }
        if(dispatch.getDispatchKeyword() != null){
            map.put("dispatchKeyword",dispatch.getDispatchKeyword());
        }else {
            map.put("dispatchKeyword","");
        }
        if(dispatch.getEmergency() != null){
            map.put("emergency",dispatch.getEmergency());
        }else {
            map.put("emergency","");
        }
        if(dispatch.getPrintNum() != null){
            map.put("printNum",dispatch.getPrintNum());
        }else {
            map.put("printNum","");
        }
        if(dispatch.getRemark() != null){
            map.put("remark",dispatch.getRemark());
        }else {
            map.put("remark","");
        }
        if(dispatch.getExigencyDegree() != null){
            map.put("exigencyDegree",dispatch.getExigencyDegree());
        }else {
            map.put("exigencyDegree","");
        }
        if(dispatch.getSerialNo() != null){
            map.put("serialNo",dispatch.getSerialNo());
        }else {
            map.put("serialNo","");
        }
        if(dispatch.getDocType() != null){
            map.put("docType",dispatch.getDocType());
        }else {
            map.put("docType","");
        }
        if(dispatch.getPublishType() != null){
            map.put("publishType",dispatch.getPublishType());
        }else {
            map.put("publishType","");
        }
        if(dispatch.getMainSend() != null){
            map.put("mainSend",dispatch.getMainSend());
        }else {
            map.put("mainSend","");
        }
        if(dispatch.getDraftDate() != null){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
//            String userDwdm = CommonUtil.getUserRegionCode();
//            if(userDwdm==null){
//                userDwdm = "";
//            }
//            HashMap hm = (HashMap)templateView.get("");
//            if(hm!=null){
//                Object type = hm.get("fwDate");
//                if(type!=null&&StringUtils.equals("draftDate",type.toString())){
//                    map.put("draftDate",sdf.format(dispatch.getDraftDate()));
//                }else {
                    map.put("draftDate",sdf.format(new Date()));
//                }
//            }
        }else {
            map.put("draftDate","");
            map.put("draftDate_zh","");
        }
        map.put("url", basePath);
        return map;
    }

    public static String parseTemplet(Dispatch zsDispatch,String basePath) throws Exception {
        Template docType = null;
        if (StringUtils.isNotBlank(zsDispatch.getDispatchName())){
            docType = getTextTemplate(zsDispatch.getDispatchName());
        } else {
            docType = getTextTemplate("空白模板");
        }
        String data = "";
        try {
            data = FreeMarkerTemplateUtils.processTemplateIntoString(docType, dispatchToMap(zsDispatch,basePath));
        }catch (Exception e){
            e.printStackTrace();
        }
        return data;
    }
}
