package com.gtis.oa.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.Constants;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Schedule;
import com.gtis.oa.mapper.ScheduleMapper;
import com.gtis.oa.model.page.SchedulePage;
import com.gtis.oa.service.ScheduleService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author jiangtong
 * @since 2019-07-18
 */
@Service
public class ScheduleServiceImpl extends ServiceImpl<ScheduleMapper, Schedule> implements ScheduleService {
    @Autowired
    private ScheduleMapper scheduleMapper;

    @Override
    public Schedule findByMap(HashMap map){
        return scheduleMapper.findByMap(map);
    }

    @Override
    public IPage<Schedule> findByPage(SchedulePage schedulePage) {
        return scheduleMapper.findByPage(schedulePage);
    }

    @Override
    public List<Schedule> getScheduleList(Map map) throws Exception {
        String statement = "getScheduleList";
        if (map == null) {
            map = new HashMap();
        }
        return scheduleMapper.getScheduleList(map);
    }

    @Override
    public Schedule getNewSchedule(Integer flag) {
        Schedule schedule = new Schedule();
        setNotNullValue(schedule);
        return schedule;
    }

    /**
     * 赋值非空字段
     * 保存之前调用
     * @param schedule
     */
    private void setNotNullValue(Schedule schedule) {
        if (schedule != null) {
            if (StringUtils.isBlank(schedule.getId())) {
                schedule.setId(UUID.hex32());
            }
            if (schedule.getIsallflag() == null) {
                schedule.setIsallflag(Constants.SCHEDULE_FLAG_PERSONAL);
            }
            if (StringUtils.isBlank(schedule.getAppointerId())) {
                schedule.setAppointerId(CommonUtil.getUserId());
            }
            if (StringUtils.isBlank(schedule.getAppointerName())) {
                schedule.setAppointerName(CommonUtil.getUsername());
            }
            if (schedule.getCreateTime() == null) {
                schedule.setCreateTime(new Date());
            }
        }
    }
}
