package com.gtis.oa.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.oa.common.utils.Constants;
import com.gtis.oa.model.PromulgatorUse;
import com.gtis.oa.mapper.PromulgatorUseMapper;
import com.gtis.oa.service.PromulgatorUseService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 用户选择参与人员 服务实现类
 * </p>
 *
 * @author jiangtong
 * @since 2019-09-02
 */
@Service
public class PromulgatorUseServiceImpl extends ServiceImpl<PromulgatorUseMapper, PromulgatorUse> implements PromulgatorUseService {
    @Autowired
    PromulgatorUseMapper promulgatorUseMapper;
    @Autowired
    PromulgatorUseService promulgatorUseService;
    @Override
    public PromulgatorUse findByMap(HashMap map){
        return promulgatorUseMapper.findByMap(map);
    }

    @Override
    public List<PromulgatorUse> getUserListDataByLinkId(String linkId){
        return  promulgatorUseMapper.getUserListDataByLinkId(linkId);
    }

    @Override
    /*@Caching(evict = {@CacheEvict(value = "pageCache", key = "new String('findPromulgatorByPage')"),
            @CacheEvict(value = "pageCache", key = "new String('findPromulgatorByPage' + #linkId)")})*/
    public Boolean saveOrUpdate(List<PromulgatorUse> promulgatorList, String linkId) {
        Boolean saveResult = true;
        String ids = "";
        List<PromulgatorUse> promulgatorOldList = getUserListDataByLinkId(linkId);
        if (promulgatorList.size()==0 && promulgatorOldList.size()>0){
            for (PromulgatorUse promulgatorUse: promulgatorOldList){
                promulgatorUseService.removeById(promulgatorUse.getId());
            }
        }else {
            if (CollectionUtils.isNotEmpty(promulgatorOldList)) {
                for (PromulgatorUse promulgatorUse: promulgatorOldList) {
                    PromulgatorUse promulgatorFind = searchPromulgatorFromListByUserId(promulgatorList, promulgatorUse.getParticipantId());
                    if (promulgatorFind == null) { // 修改后，该参与者已被移除，需要删除
                        promulgatorUseService.removeById(promulgatorUse.getId());
                    } else { // 该成员已存在，移除即将新增的
                        promulgatorList.remove(promulgatorFind);
                    }
                }
            }

            if (CollectionUtils.isNotEmpty(promulgatorList)) {
                for (PromulgatorUse promulgatorUse: promulgatorList) {
                    promulgatorUse.setLinkId(linkId);
                    setNotNullValue(promulgatorUse);
                    saveResult = this.saveOrUpdate(promulgatorUse);
                }
            }
        }

        return saveResult;
    }

    /**
     * 从列表中查找指定用户的记录
     * @param promulgatorList
     * @param userId
     * @return
     */
    private PromulgatorUse searchPromulgatorFromListByUserId(List<PromulgatorUse> promulgatorList, String userId) {
        PromulgatorUse resultPromulgator = null;
        if (CollectionUtils.isNotEmpty(promulgatorList) && StringUtils.isNotBlank(userId)) {
            for (PromulgatorUse promulgatorUse: promulgatorList) {
                if (userId.equals(promulgatorUse.getParticipantId()))  {
                    resultPromulgator = promulgatorUse;
                    break;
                }
            }
        }
        return resultPromulgator;
    }

    /**
     * 赋值非空字段
     * 保存之前调用
     * @param promulgatorUse
     */
    private void setNotNullValue(PromulgatorUse promulgatorUse) {
        if (promulgatorUse != null) {
            if (StringUtils.isEmpty(promulgatorUse.getId())) {
                promulgatorUse.setId(UUIDGenerator.generate());
            }
        }
    }
}
