package com.gtis.oa.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gtis.oa.mapper.NewsMapper;
import com.gtis.oa.model.News;
import com.gtis.oa.model.page.NewsPage;
import com.gtis.oa.service.NewsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 *  系统新闻表(通知) 服务实现类
 * </p>
 *
 * @author zhangxignwei
 * @since 2019-06-14
 */
@Service
@Transactional
public class NewsServiceImpl extends ServiceImpl<NewsMapper, News> implements NewsService {

    @Autowired
    NewsMapper oaNewsMapper;

    @Override
    public IPage<News> findByPage(NewsPage newsPage) {
        return oaNewsMapper.findByPage(newsPage);
    }

    @Override
    public News findByMap(HashMap map){
        return oaNewsMapper.findByMap(map);
    }

    @Override
    public List<News> getListByType(HashMap map){
        return oaNewsMapper.getListByType(map);
    }
}
