package com.gtis.oa.service.impl;

import com.gtis.oa.model.LawsType;
import com.gtis.oa.mapper.LawsTypeMapper;
import com.gtis.oa.service.LawsTypeService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 政策法规类型 服务实现类
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-02
 */
@Service
public class LawsTypeServiceImpl extends ServiceImpl<LawsTypeMapper, LawsType> implements LawsTypeService {

    @Autowired
    LawsTypeMapper lawsTypeMapper;

    @Override
    public List<LawsType> getLawsTypeList(HashMap map){
        return  lawsTypeMapper.getLawsTypeList(map);
    }

    @Override
    public Integer findMaxSort(HashMap map) {
        return lawsTypeMapper.findMaxSort(map);
    }

    @Override
    public List findNodeIdById(String lawstreeId) {
        return lawsTypeMapper.findNodeIdById(lawstreeId);
    }

    @Override
    public List findDyXh(String ftypeParentId, Integer sort) {
        Map params=new HashMap();
        params.put("ftypeParentId",ftypeParentId);
        params.put("sort",sort);
        return lawsTypeMapper.findDyXh(params);
    }

    /**
     * 获取政策法规网url左侧目录树
     * @param url
     */
    public Map<String,String> getLawsTypeWithUrl(String url){
        Map<String,String> map = new HashMap<String,String>();
        try {
            org.jsoup.nodes.Document doc = Jsoup.connect(url).get();
            Elements title = doc.getElementsByClass("con-left");
            Elements docsp = title.select("li");

            String elementName = null;
            for (Element element : docsp) {
                if("li-add".equals(element.className())) {
                    //获取一级树节点名称
                    elementName = element.text();
                }else if(elementName != null && !elementName.isEmpty()){
                    //获取一级树节点id和二级树节点
                    String elementUrl = element.select("a").attr("href");
                    String[] strings = elementUrl.split("/");
                    map.put(strings[4], "-1," + elementName);
                    map.put(strings[5], strings[4] + "," + replace(element.text()));
                    elementName = null;
                }else{
                    //获取二级树节点
                    String elementUrl = element.select("a").attr("href");
                    String[] strings = elementUrl.split("/");
                    map.put(strings[strings.length-2],strings[strings.length-3] + "," + replace(element.text()));
                }
            }
            return map;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String replace(String str){
        int last = str.lastIndexOf('（'); // 标记最后一个使用左括号的位置
        String temp = str.substring(0,last);
        return temp;
    }
}
