package com.gtis.oa.service.impl;

import com.alibaba.druid.sql.visitor.functions.Trim;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Laws;
import com.gtis.oa.mapper.LawsMapper;
import com.gtis.oa.model.page.LawsPage;
import com.gtis.oa.service.LawsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import static com.gtis.oa.util.CalendarUtil.formatChinaDate;

/**
 * <p>
 * 政策法规 服务实现类
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-02
 */
@Service
public class LawsServiceImpl extends ServiceImpl<LawsMapper, Laws> implements LawsService {
    @Autowired
    LawsMapper lawsMapper;

    private int countUA = 1;

    @Override
    public IPage<Laws> findByPage(LawsPage lawsPage){
        return lawsMapper.findByPage(lawsPage);
    }

    /**
     * 获取政策法规网遍历当前页列表
     * @param url
     */
    public int getLawsWithUrl(String url){
        int updateCount = 0;
        try {
            Document document = jsoupIsConnect(url);
            if(document == null){
                return updateCount;
            }else {
                Elements conTable = document.getElementsByClass("con-table");
                Elements docst = conTable.select("li");

                for (Element elementT : docst) {
                    Elements line = elementT.select("table");
                    Elements nodes = line.select("tr > td");
                    String contentUrl = nodes.get(1).select("a").attr("href");

                    //验证是否已存在
                    LawsPage lawsPage = new LawsPage();
                    lawsPage.setEffectLeve(nodes.get(13).text());
                    lawsPage.setFpubDpt(nodes.get(7).text());
                    lawsPage.setFtitle(nodes.get(1).text());
                    lawsPage.setTreeName(nodes.get(11).text());
                    lawsPage.setUserArea(nodes.get(9).text());

                    IPage<Laws> lawsIPage = findByPage(lawsPage);

                    if(lawsIPage.getRecords().size()<=0) {
                        //获取正文内容
                        Map<String,String> map = getLawsContent(contentUrl);
                        if(map != null && !map.isEmpty()) {
                            //保存政策法规
                            Laws laws = new Laws();
                            laws.setTreeName(nodes.get(11).text());
                            laws.setCreateDate(new Date());
                            laws.setDocSymbol(nodes.get(3).text().replace(" ", "").trim());
                            laws.setEffectLeve(nodes.get(13).text());
                            laws.setFpubDate(formatChinaDate(nodes.get(5).text()));
                            laws.setFpubDpt(nodes.get(7).text());
                            laws.setIsfinish(nodes.get(17).text());
                            laws.setFtitle(nodes.get(1).text());
                            laws.setLawContent(map.get("lawContent"));
                            laws.setUserArea(nodes.get(9).text());
                            laws.setFkeyword(nodes.get(1).text());
                            laws.setFinfoSource(map.get("infoSource"));
                            laws.setLawId(UUID.hex32());
                            saveOrUpdate(laws);
                            updateCount++;
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return updateCount;
    }

    /**
     * 获取政策法规网正文数据
     * @param url
     */
    public Map<String,String> getLawsContent(String url){
        Map<String,String> map = new HashMap<>();
        String contentUrl = "http://f.mnr.gov.cn" + url;
        try {
            Document document = jsoupIsConnect(contentUrl);
            if(document == null){
                return  null;
            }else {
                Element content = document.getElementById("content");
                String lawContent = content.toString();
                Elements mid = document.getElementsByClass("mid-4");
                Elements spans = mid.select("span");
                String infoSource = spans.get(2).text();
                map.put("lawContent",lawContent);
                map.put("infoSource",infoSource);
                return map;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 功能：检测当前URL是否可连接或是否有效,
     * 描述：最多连接网络 5 次, 如果 5 次都不成功，视为该地址不可用
     * @param urls 指定URL网络地址
     * @return URL
     */
    public Document jsoupIsConnect(String urls) {
        int counts = 0;
        String[] ua = {"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:46.0) Gecko/20100101 Firefox/46.0",
                "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.87 Safari/537.36 OPR/37.0.2178.32",
                "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2",
                "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36",
                "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2486.0 Safari/537.36 Edge/13.10586",
                "Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko",
                "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0)",
                "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)",
                "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; WOW64; Trident/4.0)",
                "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 BIDUBrowser/8.3 Safari/537.36",
                "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.80 Safari/537.36 Core/1.47.277.400 QQBrowser/9.4.7658.400",
                "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.116 UBrowser/5.6.12150.8 Safari/537.36",
                "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.122 Safari/537.36 SE 2.X MetaSr 1.0",
                "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.116 Safari/537.36 TheWorld 7",
                "Mozilla/5.0 (Windows NT 6.1; W…) Gecko/20100101 Firefox/60.0"};

        if (urls == null || urls.length() <= 0) {
            return null;
        }
        while (counts < 5) {
            try {
                Thread.currentThread().sleep(8000);//毫秒
                Document doc = Jsoup.connect(urls)
                        .timeout(5000)
                        .userAgent(ua[countUA%ua.length])
                        .get();
                countUA++;
                return doc;
            } catch (IOException e) {
                countUA++;
                counts++;
                System.out.print(urls + " 【访问次数:" + counts + "】 ");
                continue;
            }catch (Exception ex){

            }
        }
        return null;
    }
}
