package com.gtis.oa.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Dispatch;
import com.gtis.oa.mapper.DispatchMapper;
import com.gtis.oa.model.page.DispatchPage;
import com.gtis.oa.service.DispatchService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 发文 服务实现类
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-08
 */
@Service
public class DispatchServiceImpl extends ServiceImpl<DispatchMapper, Dispatch> implements DispatchService {

    @Autowired
    DispatchMapper dispatchMapper;

    @Override
    public Dispatch findByMap(HashMap map){
        return dispatchMapper.findByMap(map);
    }

    @Override
    public IPage<Dispatch> findByPage(DispatchPage dispatchPage) {
        return dispatchMapper.findByPage(dispatchPage);
    }

    @Override
    public Object getMaxDispatchNo(Map<String, Object> map){
        return dispatchMapper.getMaxDispatchNo(map);
    }
}
