package com.gtis.oa.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Asset;
import com.gtis.oa.model.AssetAttachment;
import com.gtis.oa.mapper.AssetAttachmentMapper;
import com.gtis.oa.model.AssetModel;
import com.gtis.oa.model.page.AssetAttachmentPage;
import com.gtis.oa.service.AssetAttachmentService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gtis.oa.service.AssetService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 固定资产关联表 服务实现类
 * </p>
 *
 * @author jiangtong
 * @since 2019-07-15
 */
@Service
public class AssetAttachmentServiceImpl extends ServiceImpl<AssetAttachmentMapper, AssetAttachment> implements AssetAttachmentService {

    @Autowired
    AssetAttachmentMapper assetAttachmentMapper;
    @Autowired
    AssetService assetService;
    @Autowired
    AssetAttachmentService assetAttachmentService;

    @Override
    public List<AssetAttachment>findByMap(HashMap map){
        return assetAttachmentMapper.findByMap(map);
     }
    @Override
    public IPage<AssetAttachment> findByPage(AssetAttachmentPage assetAttachmentPage){
        return assetAttachmentMapper.findByPage(assetAttachmentPage);
    }

    /**
     * 保存
     * @param assetModel
     */
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void saveAsset(AssetModel assetModel){
        Asset asset = null;
        if (assetModel != null) {
            asset = assetService.getById(assetModel.getId());
            if (asset != null) {
                asset.setApplyUnit(assetModel.getApplyUnit());
                asset.setApplyPeople(assetModel.getApplyPeople());
                asset.setApplyTime(assetModel.getApplyTime());
                asset.setReason(assetModel.getReason());
                assetService.updateById(asset);
            } else {
                asset = new Asset();
                asset.setId(assetModel.getId());
                asset.setApplyUnit(assetModel.getApplyUnit());
                asset.setApplyPeople(assetModel.getApplyPeople());
                asset.setApplyTime(assetModel.getApplyTime());
                asset.setReason(assetModel.getReason());
                assetService.save(asset);
            }
            if (CollectionUtils.isNotEmpty(assetModel.getAssetAttachmentList())) {
                assetModel.getAssetAttachmentList().forEach(assetAttachment -> {
                    if (assetAttachment != null) {
                        if (StringUtils.isBlank(assetAttachment.getAttId())) {
                            assetAttachment.setAttId(UUID.hex32());
                            assetAttachmentService.save(assetAttachment);
                        }
                        assetAttachmentService.updateById(assetAttachment);
                    }
                });
            }
        }
    }
}
