package com.gtis.oa.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gtis.oa.model.News;
import com.gtis.oa.model.page.NewsPage;
import org.springframework.data.domain.Pageable;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 系统新闻表(通知) 服务类
 * </p>
 *
 * @author zhangxignwei
 * @since 2019-06-14
 */
public interface NewsService extends IService<News> {

    /**
     * 根据条件分页查询
     * @param newsPage
     * @return
     */
    public IPage<News> findByPage(NewsPage newsPage);

    /**
     * 根据id查询OaFrOutgoing
     * @param map
     * @return
     */
    public News findByMap(HashMap map);

    public List<News> getListByType(HashMap map);
}
