package com.gtis.oa.model.dict;

import javax.persistence.*;
import java.util.HashSet;
import java.util.Set;

/**
 * .字典
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 14-1-17 上午8:43
 */
@Entity
@Table(name = "oa_dict")
public class Dict {

    @Id
    @Column(length = 32)
    private String id;

    @Column(length = 128, nullable = false, unique = true)
    private String name;

    @Column(length = 128)
    private String title;

    @Column(name = "order_number", columnDefinition = "number(3,0)")
    private int order = 0;

    @Column(length = 256)
    private String sql;

    @OneToMany(mappedBy = "dict", cascade = {CascadeType.ALL})
    @OrderBy(value = "order")
    private Set<DictItem> items = new HashSet<DictItem>();

    private boolean deletable = true;

    public Dict() {
    }

    public Dict(String name, String title) {
        this.name = name;
        this.title = title;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getSql() {
        return sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Set<DictItem> getItems() {
        return items;
    }

    public boolean isDeletable() {
        return deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    /**
     * add dict
     *
     * @param item
     * @return
     */
    public Dict addDictItem(DictItem item) {
        item.setDict(this);
        this.items.add(item);
        return this;
    }

    public void deleteItem(DictItem item) {
        this.items.remove(item);
    }

    public int itemSize() {
        return this.items.size();
    }

    /**
     * get DictItem by name
     *
     * @param name
     * @return
     */
    public DictItem getDictItem(String name) {
        for (DictItem item : items) {
            if (item.getName().equals(name)) return item;
        }
        throw new RuntimeException(" dict [ " + name + " ] not found");
    }

}
