package com.gtis.oa.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

/**
 * <p>
 * 日程管理
 * </p>
 *
 * @author jiangtong
 * @since 2019-07-18
 */
public class Schedule extends Model<Schedule> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "ID", type = IdType.INPUT)
    private String id;

    /**
     * 开始时间
     */
    private Date beginTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 标题
     */
    private String caption;

    /**
     * 地点
     */
    private String address;

    /**
     * 日程内容
     */
    private String content;

    /**
     * 参与者
     */
    private String participantId;

    /**
     * 日程创建人ID
     */
    private String appointerId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 是否全局标志，0个人，1全局
     */
    private Integer isallflag;

    /**
     * 日程创建人名称
     */
    private String appointerName;

    /**
     * 日程类型
     */
    private String scheduleType;

    /**
     * 循环方式
     */
    private String circleType;

    /**
     * 是否公开
     */
    private String isPublic;

    /**
     * 是否已发布
     */
    private String isPublished;

    /**
     * 是否发送短信提醒
     */
    private String isSendsms;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getParticipantId() {
        return participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public String getAppointerId() {
        return appointerId;
    }

    public void setAppointerId(String appointerId) {
        this.appointerId = appointerId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getIsallflag() {
        return isallflag;
    }

    public void setIsallflag(Integer isallflag) {
        this.isallflag = isallflag;
    }

    public String getAppointerName() {
        return appointerName;
    }

    public void setAppointerName(String appointerName) {
        this.appointerName = appointerName;
    }

    public String getScheduleType() {
        return scheduleType;
    }

    public void setScheduleType(String scheduleType) {
        this.scheduleType = scheduleType;
    }

    public String getCircleType() {
        return circleType;
    }

    public void setCircleType(String circleType) {
        this.circleType = circleType;
    }

    public String getIsPublic() {
        return isPublic;
    }

    public void setIsPublic(String isPublic) {
        this.isPublic = isPublic;
    }

    public String getIsPublished() {
        return isPublished;
    }

    public void setIsPublished(String isPublished) {
        this.isPublished = isPublished;
    }

    public String getIsSendsms() {
        return isSendsms;
    }

    public void setIsSendsms(String isSendsms) {
        this.isSendsms = isSendsms;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Schedule{" +
        "id=" + id +
        ", beginTime=" + beginTime +
        ", endTime=" + endTime +
        ", caption=" + caption +
        ", address=" + address +
        ", content=" + content +
        ", participantId=" + participantId +
        ", appointerId=" + appointerId +
        ", createTime=" + createTime +
        ", isallflag=" + isallflag +
        ", appointerName=" + appointerName +
        ", scheduleType=" + scheduleType +
        ", circleType=" + circleType +
        ", isPublic=" + isPublic +
        ", isPublished=" + isPublished +
        ", isSendsms=" + isSendsms +
        "}";
    }
}
