package com.gtis.oa.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

/**
 * <p>
 * 用户选择参与人员
 * </p>
 *
 * @author jiangtong
 * @since 2019-09-02
 */
public class PromulgatorUse extends Model<PromulgatorUse> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "ID", type = IdType.INPUT)
    private String id;

    /**
     * 关联该参与人记录所属业务记录的主键ID
     */
    private String linkId;

    /**
     * 参与人ID
     */
    private String participantId;

    /**
     * 参与人名称
     */
    private String peopleName;

    /**
     * 参与人所属部门ID
     */
    private String organId;

    /**
     * 参与人所属部门名称
     */
    private String organName;

    /**
     *  参与类型，1表示全局所有人，3表示个人
     */
    private String promulgate;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLinkId() {
        return linkId;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    public String getParticipantId() {
        return participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public String getPeopleName() {
        return peopleName;
    }

    public void setPeopleName(String peopleName) {
        this.peopleName = peopleName;
    }

    public String getOrganId() {
        return organId;
    }

    public void setOrganId(String organId) {
        this.organId = organId;
    }

    public String getOrganName() {
        return organName;
    }

    public void setOrganName(String organName) {
        this.organName = organName;
    }

    public String getPromulgate() {
        return promulgate;
    }

    public void setPromulgate(String promulgate) {
        this.promulgate = promulgate;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "PromulgatorUse{" +
        "id=" + id +
        ", linkId=" + linkId +
        ", participantId=" + participantId +
        ", peopleName=" + peopleName +
        ", organId=" + organId +
        ", organName=" + organName +
        ", promulgate=" + promulgate +
        "}";
    }
}
