package com.gtis.oa.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

/**
 * <p>
 * 出差学习、请假申请表
 * </p>
 *
 * @author zhanggupei
 * @since 2019-06-20
 */
public class Outgoing extends Model<Outgoing> {

    private static final long serialVersionUID = 1L;

    /**
     * 审批ID
     */
    @TableId(value = "ID", type = IdType.INPUT)
    private String id;

    /**
     * 申请人ID
     */
    private String peopleId;

    /**
     * 申请人姓名
     */
    private String peopleName;

    /**
     * 外出类型
     */
    private Integer outType;

    /**
     * 申请时间
     */
    private Date applyDate;

    /**
     * 开始时间
     */
    private Date beginTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 出差事由（请假事由）
     */
    private String reason;

    /**
     * 是否批准
     */
    private Integer isapprove;

    /**
     * 目的地
     */
    private String destination;

    /**
     * 科室
     */
    private String peopleUnit;

    /**
     * 请（续）、销假类型
     */
    private String applyType;

    /**
     * 是否办结
     */
    private Integer isfinished;

    /**
     * 联系方式（鹤岗）
     */
    private String peopleTel;

    /**
     * 预计到岗时间
     */
    private String arrivalTime;

    /**
     * 计划离岗时间
     */
    private String departureTime;

    /**
     * 办事路线与地点
     */
    private String outAdress;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPeopleId() {
        return peopleId;
    }

    public void setPeopleId(String peopleId) {
        this.peopleId = peopleId;
    }

    public String getPeopleName() {
        return peopleName;
    }

    public void setPeopleName(String peopleName) {
        this.peopleName = peopleName;
    }

    public Integer getOutType() {
        return outType;
    }

    public void setOutType(Integer outType) {
        this.outType = outType;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Integer getIsapprove() {
        return isapprove;
    }

    public void setIsapprove(Integer isapprove) {
        this.isapprove = isapprove;
    }

    public String getDestination() {
        return destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getPeopleUnit() {
        return peopleUnit;
    }

    public void setPeopleUnit(String peopleUnit) {
        this.peopleUnit = peopleUnit;
    }

    public String getApplyType() {
        return applyType;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }

    public Integer getIsfinished() {
        return isfinished;
    }

    public void setIsfinished(Integer isfinished) {
        this.isfinished = isfinished;
    }

    public String getPeopleTel() {
        return peopleTel;
    }

    public void setPeopleTel(String peopleTel) {
        this.peopleTel = peopleTel;
    }

    public String getArrivalTime() {
        return arrivalTime;
    }

    public void setArrivalTime(String arrivalTime) {
        this.arrivalTime = arrivalTime;
    }

    public String getDepartureTime() {
        return departureTime;
    }

    public void setDepartureTime(String departureTime) {
        this.departureTime = departureTime;
    }

    public String getOutAdress() {
        return outAdress;
    }

    public void setOutAdress(String outAdress) {
        this.outAdress = outAdress;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Outgoing{" +
        "id=" + id +
        ", peopleId=" + peopleId +
        ", peopleName=" + peopleName +
        ", outType=" + outType +
        ", applyDate=" + applyDate +
        ", beginTime=" + beginTime +
        ", endTime=" + endTime +
        ", reason=" + reason +
        ", isapprove=" + isapprove +
        ", destination=" + destination +
        ", peopleUnit=" + peopleUnit +
        ", applyType=" + applyType +
        ", isfinished=" + isfinished +
        ", peopleTel=" + peopleTel +
        ", arrivalTime=" + arrivalTime +
        ", departureTime=" + departureTime +
        ", outAdress=" + outAdress +
        "}";
    }
}
