package com.gtis.oa.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

/**
 * <p>
 * 会议室
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-04
 */
public class Meetroom extends Model<Meetroom> {

    private static final long serialVersionUID = 1L;

    /**
     * 会议室记录ID
     */
    @TableId(value = "ROOM_ID", type = IdType.INPUT)
    private String roomId;

    /**
     * 会议室名称
     */
    private String roomName;

    /**
     * 会议室描述
     */
    private String roomDescribe;

    /**
     * 可容纳人数
     */
    private Integer peopleNum;


    public String getRoomId() {
        return roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getRoomName() {
        return roomName;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public String getRoomDescribe() {
        return roomDescribe;
    }

    public void setRoomDescribe(String roomDescribe) {
        this.roomDescribe = roomDescribe;
    }

    public Integer getPeopleNum() {
        return peopleNum;
    }

    public void setPeopleNum(Integer peopleNum) {
        this.peopleNum = peopleNum;
    }

    @Override
    protected Serializable pkVal() {
        return this.roomId;
    }

    @Override
    public String toString() {
        return "Meetroom{" +
        "roomId=" + roomId +
        ", roomName=" + roomName +
        ", roomDescribe=" + roomDescribe +
        ", peopleNum=" + peopleNum +
        "}";
    }
}
