package com.gtis.oa.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 政策法规类型
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-02
 */
public class LawsType extends Model<LawsType> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "TYPE_ID", type = IdType.INPUT)
    private String typeId;

    /**
     * 父类型ID
     */
    private String ftypeParentId;

    /**
     * 父类型名称
     */
    private String ftypeParentName;

    /**
     * 名称
     */
    private String fname;

    /**
     * 备注
     */
    private String fmemo;

    /**
     * 是否可用
     */
    private String isUse;

    /**
     * 排序
     */
    private Integer sort;

    /**
     * 子菜单
     * @TableField(exist = false)：表示该属性不为数据库表字段，但又是必须使用的。
     * @TableField(exist = true)：表示该属性为数据库表字段。
     */
    @TableField(exist = false)
    private List<LawsType> childrenList;

    public String getTypeId() {
        return typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getFtypeParentId() {
        return ftypeParentId;
    }

    public void setFtypeParentId(String ftypeParentId) {
        this.ftypeParentId = ftypeParentId;
    }

    public String getFtypeParentName() {
        return ftypeParentName;
    }

    public void setFtypeParentName(String ftypeParentName) {
        this.ftypeParentName = ftypeParentName;
    }

    public String getFname() {
        return fname;
    }

    public void setFname(String fname) {
        this.fname = fname;
    }

    public String getFmemo() {
        return fmemo;
    }

    public void setFmemo(String fmemo) {
        this.fmemo = fmemo;
    }

    public String getIsUse() {
        return isUse;
    }

    public void setIsUse(String isUse) {
        this.isUse = isUse;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public List<LawsType> getChildrenList() {
        return childrenList;
    }

    public void setChildrenList(List<LawsType> childrenList) {
        this.childrenList = childrenList;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "LawsType{" +
        "typeId=" + typeId +
        ", ftypeParentId=" + ftypeParentId +
        ", ftypeParentName=" + ftypeParentName +
        ", fname=" + fname +
        ", fmemo=" + fmemo +
        ", isUse=" + isUse +
        "}";
    }
}
