package com.gtis.oa.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

/**
 * <p>
 * 固定资产关联表
 * </p>
 *
 * @author jiangtong
 * @since 2019-07-15
 */
public class AssetAttachment extends Model<AssetAttachment> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ATT_ID", type = IdType.INPUT)
    private String attId;

    /**
     * 关联ASSET表ID
     */
    private String assetId;

    /**
     * 物品分类
     */
    private String assetType;

    /**
     * 物品名称
     */
    private String assetName;

    /**
     * 物品型号
     */
    private String assetModel;

    /**
     * 单价
     */
    private String assetPrice;

    /**
     * 数量
     */
    private String assetNum;

    /**
     * 计量单位
     */
    private String assetUnit;


    public String getAttId() {
        return attId;
    }

    public void setAttId(String attId) {
        this.attId = attId;
    }

    public String getAssetId() {
        return assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getAssetType() {
        return assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public String getAssetName() {
        return assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public String getAssetModel() {
        return assetModel;
    }

    public void setAssetModel(String assetModel) {
        this.assetModel = assetModel;
    }

    public String getAssetPrice() {
        return assetPrice;
    }

    public void setAssetPrice(String assetPrice) {
        this.assetPrice = assetPrice;
    }

    public String getAssetNum() {
        return assetNum;
    }

    public void setAssetNum(String assetNum) {
        this.assetNum = assetNum;
    }

    public String getAssetUnit() {
        return assetUnit;
    }

    public void setAssetUnit(String assetUnit) {
        this.assetUnit = assetUnit;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "AssetAttachment{" +
        "attId=" + attId +
        ", assetId=" + assetId +
        ", assetType=" + assetType +
        ", assetName=" + assetName +
        ", assetModel=" + assetModel +
        ", assetPrice=" + assetPrice +
        ", assetNum=" + assetNum +
        ", assetUnit=" + assetUnit +
        "}";
    }
}
