package com.gtis.oa.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 固定资产
 * </p>
 *
 * @author jiangtong
 * @since 2019-07-15
 */
public class Asset extends Model<Asset> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "ID", type = IdType.INPUT)
    private String id;

    /**
     * 申请单位
     */
    private String applyUnit;

    /**
     * 申请人
     */
    private String applyPeople;

    /**
     * 申请时间
     */
    private Date applyTime;

    /**
     * 申请理由
     */
    private String reason;

    @TableField(exist = false)
    private List<AssetAttachment> assetAttachmentList;

    public List<AssetAttachment> getAssetAttachmentList() {
        return assetAttachmentList;
    }

    public void setAssetAttachmentList(List<AssetAttachment> assetAttachmentList) {
        this.assetAttachmentList = assetAttachmentList;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApplyUnit() {
        return applyUnit;
    }

    public void setApplyUnit(String applyUnit) {
        this.applyUnit = applyUnit;
    }

    public String getApplyPeople() {
        return applyPeople;
    }

    public void setApplyPeople(String applyPeople) {
        this.applyPeople = applyPeople;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    protected Serializable pkVal() {
        return null;
    }

    @Override
    public String toString() {
        return "Asset{" +
        "id=" + id +
        ", applyUnit=" + applyUnit +
        ", applyPeople=" + applyPeople +
        ", applyTime=" + applyTime +
        ", reason=" + reason +
        "}";
    }
}
