package com.gtis.oa.mapper;

import com.gtis.oa.model.LawsType;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 政策法规类型 Mapper 接口
 * </p>
 *
 * @author zhanggupei
 * @since 2019-07-02
 */
public interface LawsTypeMapper extends BaseMapper<LawsType> {

    /**
     * 查询所有可用政策法规类型
     * @param map
     * @return
     */
    public List<LawsType> getLawsTypeList(HashMap map);

    /**
     * 查询某个类型的最大序号
     * @param map
     * @return
     */
    Integer findMaxSort(HashMap map);

    /**
     * 根据id查询本节点的id及所属子节点id
     * @param lawstreeId
     * @return
     */
    List  findNodeIdById(String lawstreeId);

    /**
     * 查询大于所删除的节点序号的节点
     * @param params
     * @return
     */
    List  findDyXh(Map params);

    /**
     * 保存政策法规目录树
     */
    void saveTreeLawsType();
}
