package com.gtis.oa.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.Usecar;
import com.gtis.oa.model.page.UsecarPage;
import com.gtis.oa.service.CarService;
import com.gtis.oa.service.UsecarService;
import com.gtis.oa.util.CommonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author zhanggupei
 * @since 2019-06-25
 */
@Controller
@RequestMapping("/usecar")
public class UsecarController {

    @Autowired
    UsecarService usecarService;
    @Autowired
    CarService carService;

    /**
     * 跳转数据详情页
     * @param model
     * @param processInsId
     * @return
     */
    @RequestMapping(value = "/index")
    public String index(Model model, String processInsId,String view) {
        Usecar usecar = null;
        if (StringUtils.isNotBlank(processInsId)) {
            usecar = usecarService.getById(processInsId);
        }
        if(usecar == null){
            usecar = new Usecar();
            usecar.setId(processInsId);
            usecar.setAppProple(CommonUtil.getUser().getAlias());
            usecar.setAppUnit(CommonUtil.getUser().getOrgRecordList().get(0).getName());
            usecarService.save(usecar);
        } else {
            model.addAttribute("carNo",carService.getById(usecar.getCarid()).getCarNo());
            model.addAttribute("diverName",carService.getById(usecar.getCarid()).getDriverName());
        }
        model.addAttribute("usecar", usecar);
        model.addAttribute("view",view);
        return "officeapply/useCar/usecar_edit";

    }

    /**
     * 列表页
     * @return
     */
    @RequestMapping("/list")
    public String list(Model model,String type){
        model.addAttribute("type",type);
        return "officeapply/useCar/usecar_list";
    }

    /**
     * 根据查询条件分页查询
     * @param usecarPage
     * @return
     */
    @RequestMapping("/findByPage")
    @ResponseBody
    public Map<String,Object> findByPage(UsecarPage usecarPage, long page, long limit){
        usecarPage.setCurrent(page);
        usecarPage.setSize(limit);
        IPage<Usecar> usecarIPage = usecarService.findByPage(usecarPage);
        Map<String,Object> resultMap = new HashMap<>();
        resultMap.put("code","0");
        resultMap.put("data",usecarIPage.getRecords());
        resultMap.put("count",usecarIPage.getTotal());
        return resultMap;
    }

    /**
     * 更新或新增
     * @param usecar
     */
    @RequestMapping("/save")
    @ResponseBody
    public ResponseMessage<Usecar> save(Usecar usecar){
        return new ResponseMessage<Usecar>(usecarService.saveOrUpdate(usecar),usecar);
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    @ResponseBody
    public ResponseMessage<Usecar> delete(String[] ids){
        return new ResponseMessage<>(usecarService.removeByIds(Arrays.asList(ids)));
    }

    /**
     * 列表页
     * @return
     */
    @RequestMapping("/selectList")
    public String selectList(Model model,String id){
        model.addAttribute("id",id);
        return "officeapply/useCar/car_select";
    }

    /**
     * 保存选择的车辆
     * @param id
     * @param carId
     * @return
     */
    @RequestMapping("/saveSelectedCar")
    @ResponseBody
    public ResponseMessage<Usecar> saveSelectedCar(String id,String carId){
        Usecar usecar = null;
        ResponseMessage<Usecar> temp = null;
        try{
            if(StringUtils.isNotBlank(id)){
                usecar = usecarService.getById(id);
            }
            if(usecar == null){
                usecar = new Usecar();
                usecar.setId(id);
                usecar.setCarid(carId);
                temp = new ResponseMessage<Usecar>(usecarService.save(usecar),usecar);
            }else{
                usecar.setCarid(carId);
                temp =  new ResponseMessage<Usecar>(usecarService.updateById(usecar),usecar);
            }

        } catch (Exception e){
            e.printStackTrace();
        }
        return temp;
    }
}

